import { LevelBase } from "@/pages/GamePage/Components/LevelBase.ts";
import { Assets, Sprite } from "pixi.js";
import { Ease, Tween } from "@/core/tween";
import { GameEvent, globalEvent } from "@/pages/GamePage/GameEvent.ts";

export class Level13 extends LevelBase {

  level: number = 13;

  A: Sprite;
  B: Sprite;
  C: Sprite;

  right: Sprite;
  error: Sprite;

  onLoad() {
    super.onLoad();

    this.addChild(new Sprite(Assets.get(`level${this.level}/D.png`)))
      .position.set(198, 687);

    this.B = this.addChild(new Sprite(Assets.get(`level${this.level}/B.png`)));
    this.B.position.set(463, 1086);

    this.C = this.addChild(new Sprite(Assets.get(`level${this.level}/C.png`)));
    this.C.position.set(198, 687);

    this.A = this.addChild(new Sprite(Assets.get(`level${this.level}/A.png`)));
    this.A.position.set(161, 1086);

    this.right = this.addChild(new Sprite(Assets.get(`level${this.level}/right.png`)));
    this.right.position.set(255, 916);
    this.right.alpha = 0;
    this.right.interactive = false;
    this.right.eventMode = "none";

    this.C.on("pointerdown", this.onAPointerDown, this);
    this.C.on("pointerup", this.onAPointerUp, this);
    this.C.on("globalpointermove", this.onAPointerMove, this);
  }

  pos = null;

  onAPointerUp(e) {
    this.pos = null;
  }

  onAPointerDown(e) {
    const { x, y } = e.data.global;
    this.pos = {
      x: x - this.C.x,
      y: y - this.C.y
    }
  }

  onAPointerMove(e) {
    if (!this.pos) return;
    const { x, y } = e.data.global;
    const nx = x - this.pos.x;
    const ny = y - this.pos.y;
    this.C.position.set(nx, ny);

    if (
      nx < 10 || nx > 410
      || ny < 480 || ny > 900
    ) {
      this.setTouchEnable(false);
      Tween.get(this.right)
        .to({ alpha: 1 }, 444, Ease.quadInOut)
        .wait(2000)
        .call(() => {
          globalEvent.emit(GameEvent.NextLevel);
        });
    }
  }

  onDestroy() {
    super.onDestroy();
    Tween.removeTweens(this.right);
    this.A.off("globalpointermove", this.onAPointerMove, this);
  }

}
