'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './rulepop.less';
import store from '../../store/store';
import { Button } from '@grace/ui';
import {_asyncThrottle} from "../../utils/utils";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import { LOG_KEY, MatterShareOpt, MatterViewOpt, pageView, sensorLog,MatterViewDuration } from '../../utils/sensors.js';
@observer
class Rulepop extends React.Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {
    store.initRule();

    pageView("b14294", {
        page_name: "活动规则弹窗",
    });

    sensorLog(LOG_KEY.exposure, "b14294", "d14295", {
        page_name: "活动规则弹窗",
        button_name: "关闭按钮",
    });
  }

  handleClose = _asyncThrottle(() => {
    sensorLog(LOG_KEY.click, "b14294", "d14295", {
      page_name: "活动规则弹窗",
      button_name: "关闭按钮",
    });
    ModalCtrl.closeModal()
  })

  render() {
    return (
      <div className="rulepop modal_center">
        <span className="bg"></span>
        <span className="rule" dangerouslySetInnerHTML={{ __html: store.ruleInfo }}></span>
        <Button className="close md28" onClick={this.handleClose} />
      </div>
    );
  }
}
export default Rulepop;
