import { LevelBase } from "@/pages/GamePage/Components/LevelBase.ts";
import { Assets, Sprite } from "pixi.js";
import { Ease, Tween } from "@/core/tween";
import { GameEvent, globalEvent } from "@/pages/GamePage/GameEvent.ts";

export const CIRCLE_POS = [
  { x: 71, y: 939 },
  { x: 51, y: 1025 },
  { x: 225, y: 902 },
  { x: 247, y: 1032 },
  { x: 376, y: 773 },
  { x: 383, y: 924 },
  { x: 336, y: 1058 },
  { x: 512, y: 1024 },
  { x: 600, y: 941 },
  { x: 537, y: 840 },
]

export class Level17 extends LevelBase {

  level: number = 17;

  picture: Sprite;

  circleArr = []

  clickCircleArr = []


  onLoad() {
    super.onLoad();

    this.picture = this.addChild(new Sprite(Assets.get(`level${this.level}/img.png`)));
    this.picture.position.set(47, 736);

    CIRCLE_POS.map((item, index) => {
      const circle = this.addChild(new Sprite(Assets.get(`level${this.level}/circle${index}.png`)));
      circle.position.set(item.x, item.y);
      this.circleArr.push(circle);
      circle.alpha = 0;
    })

    this.on("pointertap", this.findAnimal, this);


  }

  pos = null;

  findNum = 0;
  findAnimal(e) {
    const { x, y } = e.data.global;
    this.pos = {
      x: x,
      y: y
    }

    console.error(this.pos)


    this.circleArr.map((item, index) => {
      if(this.pos.x >= item.x && this.pos.x <= item.x + item.width && this.pos.y >= item.y && this.pos.y <= item.y + item.height) {
        if (item.findFlag) return;
        item.findFlag = true;
        Tween.get(item)
        .to({ alpha: 1 }, 444, Ease.quadInOut)
        .call(() => {
          this.findNum++;
          if(this.findNum == 10) {
            this.setPauseCd(true);
            console.log(123123123123)
            globalEvent.emit(GameEvent.NextLevel);
          }
        })
      }
    })



  }


  onDestroy() {
    super.onDestroy();

  }

}
