'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import { unwatchPageVisibility, watchPageVisibility } from '@/core/page-visibility-notify.ts';
// import { handleLogClick, handleLogExposure } from '../../../MD';
// import { RES_PATH } from '../../../sparkrc';
import { _asyncThrottle, _throttle } from '../../utils/utils.ts';
import { TASK_CODE, CHANNEL_PARAMS, extranceName } from '../../utils/constants.ts';
import { setCookies } from '../../store/fetcher.ts';
import taskStore from '../../store/task.ts';
import { LOG_KEY, MatterShareOpt, MatterViewOpt, pageView, sensorLog, MatterViewDuration } from '../../utils/sensors';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import { Button } from '@grace/ui';
import store from '@/store/store';
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import HomePage from '@/pages/HomePage/HomePage.tsx';
import GiftPackPopup from '@/panels/GiftPackPopup/index.jsx';

const cities = [
    { spId: 'sp_landmark1', name: '北京' },
    { spId: 'sp_landmark2', name: '西安' },
    { spId: 'sp_landmark3', name: '上海' },
    { spId: 'sp_landmark4', name: '杭州' },
    { spId: 'sp_landmark5', name: '成都' }
];
@observer
class VictoryPopup extends React.Component {
    constructor(props) {
        super(props);
        this.state = props;
    }

    componentDidMount = async () => {
        pageView("b14608", {
            page_name: "成功解锁地标页面",
        });
        sensorLog(LOG_KEY.exposure, "b14608", "d14610", {
            page_name: "成功解锁地标页面",
            button_name: "关闭按钮",
        });
        sensorLog(LOG_KEY.exposure, "b14608", "d14609", {
            page_name: "成功解锁地标页面",
            button_name: "去抽奖按钮",
        });
    };

    //关闭
    onClose = () => {
        sensorLog(LOG_KEY.click, "b14608", "d14610", {
          page_name: "成功解锁地标页面",
          button_name: "关闭按钮",
        });
        ModalCtrl.closeModal();
        PageCtrl.changePage(HomePage)
    }

    //抽奖
    onDraw = async () => {
        sensorLog(LOG_KEY.click, "b14608", "d14609", {
          page_name: "成功解锁地标页面",
          button_name: "去抽奖按钮",
        });
        ModalCtrl.closeModal();
        // ModalCtrl.showModal(GiftPackPopup);
        await store.getDrawInfo();
        store.doLotttery();
    }

    render() {
        const { gotSpInfo, rewardDrawTimes } = this.state;
        return (
            <div className="VictoryPopup">
                <div className="vp_mask"></div>
                <div className='vp_bg'>
                    <div className='vp_title'></div>
                    <div className='vp_ditu_txt'>{gotSpInfo.name}地图</div>
                    <div className='vp_guang'></div>
                    <div className={'vp_xz_icon vp_xz_icon_' + gotSpInfo.spId}></div>
                    <div className='vp_cjjh_tips'>
                        <div>抽奖机会+{rewardDrawTimes}</div>
                    </div>
                    <div className='vp_btn md15' onClick={() => this.onDraw()}></div>
                    <div className='vp_close md16' onClick={() => this.onClose()}></div>
                </div>
            </div>
        );
    }
};

export default VictoryPopup;