'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './rulepop.less';
import store from '../../store/store';
import { Button } from '@grace/ui';
import {_asyncThrottle} from "../../utils/utils";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";

@observer
class Rulepop extends React.Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {
    store.initRule();
  }

  handleClose = _asyncThrottle(() => {
    ModalCtrl.closeModal()
  })

  render() {
    return (
      <div className="rulepop modal_center">
        <span className="bg"></span>
        <span className="title"></span>
        <span className="rule" dangerouslySetInnerHTML={{ __html: store.ruleInfo }}></span>
        <Button className="close" onClick={this.handleClose} />
      </div>
    );
  }
}
export default Rulepop;
