import React from "react";
import {observer} from "mobx-react";
import "./TipPanel.less";
import {Button} from "@grace/ui";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";

export interface ITipPanelProps {
  tip: string;
  onClose: () => void;
}

@observer
class TipPanel extends React.Component<ITipPanelProps> {

  componentDidMount() {
  }

  clickClose = () => {
    ModalCtrl.closeModal();
    this.props.onClose && this.props.onClose();
  };

  clickBtn = () => {
    ModalCtrl.closeModal();
    this.props.onClose && this.props.onClose();
  };

  render() {
    const { tip } = this.props;

    const isNoTimes = tip === "获取提示机会已用完";

    return <div className="TipPanel modal_center">
      <div className="bg"/>
      <div className="text" dangerouslySetInnerHTML={{
        __html: tip,
      }}/>
      <Button className={`btn md${isNoTimes ? 24 : 15}`} onClick={this.clickBtn}/>
      <Button className={`close ${isNoTimes ? "" : "md16"}`} onClick={this.clickClose}/>
    </div>;
  }
}

export default TipPanel;
