"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./mappage.less";
import { dateFormatter, getUrlParam, isMiniprogram, windowJumpUrl } from "@/utils/utils.ts";
// import { accessLog } from "duiba-utils";
import store from "@/store/store.ts";
import API from "@/api";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import HomePage from '../HomePage/HomePage.tsx';
import { handleLogClick, handleLogExposure } from "../../MD.js";
import { LOG_KEY, MatterViewDuration, MatterViewOpt, sensorLog } from "../../utils/sensors.js";
import { _throttle } from "@/utils/utils.js";
import { Button, Toast } from "@grace/ui";
//研学地图页面+地图详情

const cities = [
  { name: '北京', icon: '../src/assets/mapPage/icon_1.png', lock_icon: '../src/assets/mapPage/lock_icon_1.png' },
  { name: '西安', icon: '../src/assets/mapPage/icon_2.png', lock_icon: '../src/assets/mapPage/lock_icon_2.png' },
  { name: '上海', icon: '../src/assets/mapPage/icon_3.png', lock_icon: '../src/assets/mapPage/lock_icon_3.png' },
  { name: '杭州', icon: '../src/assets/mapPage/icon_4.png', lock_icon: '../src/assets/mapPage/lock_icon_4.png' },
  { name: '成都', icon: '../src/assets/mapPage/icon_5.png', lock_icon: '../src/assets/mapPage/lock_icon_5.png' }
];

const cities_info = [
  { name: '北京', icon: '../src/assets/mapPage/map_info_1.png' },
  { name: '西安', icon: '../src/assets/mapPage/map_info_2.png' },
  { name: '上海', icon: '../src/assets/mapPage/map_info_3.png' },
  { name: '杭州', icon: '../src/assets/mapPage/map_info_4.png' },
  { name: '成都', icon: '../src/assets/mapPage/map_info_5.png' }
];

@observer
class Mappage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      curIndex: 0,
      spInfoList: []
    };
  }

  componentDidMount() {
    this.getMapInfo();

  }
  getMapInfo = async () => {

    let res = await API.mapInfo();
    res = {
      "success": true,
      "code": "",
      "message": "",
      "data": {
        "spInfoList": [
          {
            "spId": "sp_landmark1",
            "name": "北京",
            "icon": "https://www.baidu.com/tiananmen.png",
            "unlockFlag": true
          },
          {
            "spId": "sp_landmark2",
            "name": "上海",
            "icon": "https://www.baidu.com/dongfangmingzhu.png",
            "unlockFlag": false
          },
          {
            "spId": "sp_landmark3",
            "name": "广州",
            "icon": "https://www.baidu.com/guangzhouta.png",
            "unlockFlag": false
          },
          {
            "spId": "sp_landmark4",
            "name": "深圳",
            "icon": "https://www.baidu.com/shenzhendiwangdasha.png",
            "unlockFlag": true
          },
          {
            "spId": "sp_landmark5",
            "name": "杭州",
            "icon": "https://www.baidu.com/hangzhoudasha.png",
            "unlockFlag": false
          }
        ]
      }
    }
    console.log('res:::::', res);
    if (res?.success) {
      this.setState({
        spInfoList: res.data.spInfoList
      })
    }
  }

  onBack = () => {
    PageCtrl.changePage(HomePage);
  }

  onSee = (index) => {
    const { curIndex, spInfoList } = this.state;
    if (!spInfoList[index].unlockFlag) {
      Toast.show("当前城市未解锁，快去参与游戏解锁吧~");
      return;
    }
    this.setState({
      curIndex: index + 1
    })
    console.log('查看:', index + 1)
  }

  onInfoClose = () => {
    this.setState({
      curIndex: 0
    })
    console.log('关闭')
  }

  render() {
    const { curIndex, spInfoList } = this.state;
    return (
      <div className="Mappage">
        <div className="map_bg">
          <div className="back_btn" onClick={this.onBack}></div>
          <div className="map_title"></div>
          <div className="city_box">
            {spInfoList.map((city, index) => (
              <div key={index} className="city_card">
                <div className="city_icon" style={{ backgroundImage: `url(${city.unlockFlag ? cities[index].icon : cities[index].lock_icon})` }}>
                </div>
                <div className="city_overlay">
                  <div className="city_name">{city.name}</div>
                  <div className={city.unlockFlag ? 'see_btn' : 'lock_see_btn'} onClick={() => this.onSee(index)}></div>
                </div>
              </div>
            ))}
          </div>
        </div>
        <div className="info_box" style={{ 'display': curIndex > 0 ? 'block' : 'none' }}>
          <div className="info_mask"></div>
          <div className={"info_img info_img_" + curIndex}></div>
          <div className="close_btn" onClick={this.onInfoClose}></div>
        </div>
      </div >
    );
  }
}
export default Mappage;
