'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './yinsirulepop.less';
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { _asyncThrottle } from '../../utils/utils.ts';
import API from '../../api/index.ts';
import store from '../../store/store.ts';
import { LOG_KEY, MatterShareOpt, MatterViewOpt, pageView, sensorLog,MatterViewDuration } from '../../utils/sensors.js';
import MyPrize from '../../pages/MyPrize/MyPrize.jsx';
@observer
class Yinsirulepop extends React.Component {
  constructor(props) {
    super(props);
  }
  componentDidMount() {

    pageView("b14624", {
        page_name: "隐私协议页",
    });

    sensorLog(LOG_KEY.exposure, "b14624", "d14625", {
        page_name: "隐私协议页",
        button_name: "同意按钮",
    });
  }
  clickClose = () => {
    ModalCtrl.closeModal();
  }

  clickTo = _asyncThrottle(async () => {
    sensorLog(LOG_KEY.click, "b14624", "d14625", {
      page_name: "隐私协议页",
      button_name: "同意按钮",
    });
    const {success} = await API.agreePrivacy()
    if (!success) return
    PageCtrl.changePage(MyPrize);
    ModalCtrl.closeModal();
  })
  render() {
    return (
      <div className="yinsirulepop modal_center">
        <div className="cont">
          <span className="bg"></span>
          <span className="close" onClick={this.clickClose}></span>
          <div className="ruletext"
             dangerouslySetInnerHTML={{
               __html: store?.indexData?.privacyContent,
             }}/>
          <span className="btn md35" onClick={this.clickTo}></span>
        </div>
      </div>
    );
  }
}
export default Yinsirulepop;
