'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './homepage.less';
import { Button, Toast } from '@grace/ui';
import { _asyncThrottle, windowJumpUrl, getUrlParam } from "../../utils/utils";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import Rulepop from "../../components/rulepop/rulepop.jsx";
import { isWeiXin } from "../../AppTools.ts";
import store from '@/store/store';
import Taskpop from '@/panels/taskpop/taskpop.jsx';
import Yinsirulepop from '@/panels/yinsirulepop/yinsirulepop.jsx';
import MyPrize from '../MyPrize/MyPrize.jsx';
import shareStore from '@/store/share.js';
import { LOG_KEY, MatterShareOpt, MatterViewDuration, MatterViewOpt, pageView, sensorLog } from "@/utils/sensors.js";
import { CHANNEL_PARAMS, extranceName } from '@/utils/constants.js';
import gameStore from "@/store/gameStore.ts";
import GamePage from "@/pages/GamePage/GamePage.tsx";
import MapPage from "@/pages/MapPage/mappage.jsx";
import MusicBtn from '@/core/components/MusicBtn/MusicBtn.tsx';
import { SvgaPlayer } from "@grace/svgaplayer";
import { Swiper, SwiperSlide } from "swiper/react";
import { Autoplay } from "swiper";
import "swiper/css";
import { onInitShare } from '@/utils/share.ts';
const startTime = +new Date()
@observer
class Homepage extends React.Component {
  constructor(props) {
    super(props);
    this.handleButtonClick = this.handleButtonClick.bind(this);
  }

  async componentDidMount() {
    if (isWeiXin()) {
      if (!await store.checkBindStatus()) return;
    }
    await shareStore.doAssist();
    await store.updateIndex();
    await store.getDrawInfo();
    this.initSensor();
  }
  componentWillUnmount() {
    if (CFG.channel == CHANNEL_PARAMS.YK_MINI || CFG.channel == CHANNEL_PARAMS.YK_PUBLIC) {
      MatterViewDuration("b14605", +new Date() - startTime, {
        page_name: "友客首页",
      });
    }
  }
  handleButtonClick = _asyncThrottle(async (number) => {
    // 活动时间判断
    // 规则 奖品始终可以点击 其余常规逻辑
    if (!(number === 4 || number === 5)) {
      if ((!store.judgeActTime(true, true))) return;
    }
    switch (number) {
      // 0 研学地图
      case 0:
        sensorLog(LOG_KEY.click, "b14598", "d14602", {
          page_name: "活动首页",
          button_name: "研学地图按钮",
        });
        PageCtrl.changePage(MapPage);
        break;

      // 1 抽奖
      case 1:
        sensorLog(LOG_KEY.click, "b14598", "d14601", {
          page_name: "活动首页",
          button_name: "抽奖按钮",
        });
        store.doLotttery();
        break;

      // 2 做任务
      case 2:
        sensorLog(LOG_KEY.click, "b14598", "d14604", {
          page_name: "活动首页",
          button_name: "赚次数按钮",
        });
        ModalCtrl.showModal(Taskpop);
        break;

      // 3 开始游戏
      case 3:
        sensorLog(LOG_KEY.click, "b14598", "d14603", {
          page_name: "活动首页",
          button_name: "开始游戏按钮",
        });

        if (!store.indexData?.leftGameTimes) {
          Toast.show("游戏次数不足，快去做任务赚次数吧～")
          return;
        }
        const suc = await gameStore.start();
        if (suc) {
          PageCtrl.changePage(GamePage);
        }

        break;

      // 4 我的奖品
      case 4:
        sensorLog(LOG_KEY.click, "b14598", "d14600", {
          page_name: "活动首页",
          button_name: "奖品按钮",
        });
        if (!store.indexData?.agreePrivacyFlag) {
          ModalCtrl.showModal(Yinsirulepop);
        } else {
          PageCtrl.changePage(MyPrize);
        }

        break;

      // 5 活动规则
      case 5:
        sensorLog(LOG_KEY.click, "b14598", "d14599", {
          page_name: "活动首页",
          button_name: "规则按钮",
        });
        ModalCtrl.showModal(Rulepop);
        break;

      // 6 拜访清单
      case 6:
        sensorLog(LOG_KEY.click, "b14605", "d14606", {
          page_name: "友客首页",
          button_name: "拜访清单按钮",
        });
        windowJumpUrl(store.frontVariable?.SaleManUrl
          + "&actPlatforms=" + getUrlParam("actPlatforms")
          + "&agentCode=" + getUrlParam("agentCode")
          + "&actId=" + getUrlParam("actId")
          + "&channel=" + CFG.channel);
        break;

      // 7 分享活动
      case 7:
        MatterShareOpt("b14605", "d14607", {
          button_name: "分享活动按钮",
          page_name: "友客首页",
        })
        shareStore.doShare();
        break;

      default:
        console.warn("未知按钮类型", number);
    }
  })
  initSensor = () => {
    if (CFG.channel == CHANNEL_PARAMS.YK_MINI) {
      sensorLog(LOG_KEY.exposure, "b14605", "d14607", {
        page_name: "友客首页",
        button_name: "分享活动按钮",
      });
    }

    if (CFG.channel == CHANNEL_PARAMS.YK_MINI || CFG.channel == CHANNEL_PARAMS.YK_PUBLIC) {
      MatterViewOpt("b14605", {
        page_name: "友客首页",
      })
      if (store?.indexData?.isAgent) {
        sensorLog(LOG_KEY.exposure, "b14605", "d14606", {
          page_name: "友客首页",
          button_name: "拜访清单按钮",
        });
      }
    }

    pageView("b14598", {
      page_name: "活动首页"
    });

    sensorLog(LOG_KEY.exposure, "b14598", "d14604", {
      page_name: "活动首页",
      button_name: "赚次数按钮",
    });
    sensorLog(LOG_KEY.exposure, "b14598", "d14601", {
      page_name: "活动首页",
      button_name: "抽奖按钮",
    });
    sensorLog(LOG_KEY.exposure, "b14598", "d14603", {
      page_name: "活动首页",
      button_name: "开始游戏按钮",
    });
    sensorLog(LOG_KEY.exposure, "b14598", "d14602", {
      page_name: "活动首页",
      button_name: "研学地图按钮",
    });
    sensorLog(LOG_KEY.exposure, "b14598", "d14600", {
      page_name: "活动首页",
      button_name: "奖品按钮",
    });
    sensorLog(LOG_KEY.exposure, "b14598", "d14599", {
      page_name: "活动首页",
      button_name: "规则按钮",
    });
  };
  render() {
    const { uid, leftGameTimes, isAgent } = store?.indexData || {}
    const { optionInfoList, leftDrawTimes } = store?.drawData || {}
    return (
      <div className="homepage modal_center">
        <span className="bg"></span>
        <span className="icon"></span>
        <span className="title"></span>
        {/* 按钮 */}
        <div className="rank">
          <span className="r_bg"></span>
          <span className="name">用户id:{uid}</span>
        </div>
        <span className="logo"></span>
        <Button className="draw md10" onClick={() => this.handleButtonClick(1)}>
          <span className="draw_num">{leftDrawTimes || 0}</span>
        </Button>
        <Button className="study_map md12" onClick={() => this.handleButtonClick(0)} />
        <Button className="task md11" onClick={() => this.handleButtonClick(2)} />
        <Button className="matter md9" onClick={() => this.handleButtonClick(3)}>
          <span className="m_bg"></span>
          <span className="remain">剩余次数：{leftGameTimes}</span>
        </Button>
        <Button className="prize md5" onClick={() => this.handleButtonClick(4)} />
        <Button className="rule md4" onClick={() => this.handleButtonClick(5)} />
        {(+CFG.channel == 3 || +CFG.channel == 5) && isAgent && <Button className="visit md7" onClick={() => this.handleButtonClick(6)} />}
        {+CFG.channel == 5 && isAgent && <Button className="share md8" onClick={() => this.handleButtonClick(7)} />}

        <MusicBtn className="musicBtn md6" />

        {/* 底部奖品轮播 */}
        <div className="prize_list_box">
          <div className="prize_list">
            <Swiper
              autoplay={{
                disableOnInteraction: false,
                delay: 300,
              }}
              modules={[Autoplay]}
              slidesPerView={4.2}
              loop={true}
              initialSlide={0}
              speed={1600}
              freeMode={true}
            >
              {optionInfoList?.map((item, index) => (
                <SwiperSlide key={index}>
                  <div className="psample">
                    <img className="psimg" src={item.icon} />
                    <span className="psname">{item.name}</span>
                  </div>
                </SwiperSlide>
              ))}
            </Swiper>
          </div>
        </div>
      </div>
    );
  }
}
export default Homepage;
