'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import { _asyncThrottle, _throttle } from '../../utils/utils.ts';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import store from "@/store/store.js";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import HomePage from '@/pages/HomePage/HomePage.tsx';

@observer
class AwardPopup extends React.Component {
    constructor(props) {
        super(props);
        // console.log('ddddd::::::', props);
        this.state = {
            prize: props.prize
        };
    }

    //关闭
    onClose = () => {
        ModalCtrl.closeModal();
        PageCtrl.changePage(HomePage);
    }

    //开心收下
    onReceive = () => {
        ModalCtrl.closeModal();
        PageCtrl.changePage(HomePage);
    }

    setOptionName = (str, maxLength = 10) => {
        return str.length > maxLength
            ? str.substring(0, maxLength) + '...'
            : str;
    }

    render() {
        const { prize } = this.state;
        return (
            <div className="AwardPopup">
                <div className="ap_mask"></div>
                <div className='ap_bg'>
                    <div className='ap_txt'>成功获得奖品</div>
                    <div className='ap_icon' style={{ backgroundImage: `url(${prize.optionImg})` }}></div>
                    <div className='ap_award_name'>{this.setOptionName(prize.optionName, 15)}</div>
                    <div className='ap_btn md18' onClick={() => this.onReceive()}></div>
                </div>
                <div className='ap_close' onClick={() => this.onClose()}></div>
            </div >
        );
    }
};

export default AwardPopup;