import React from 'react';
import { observer } from 'mobx-react';
import './RankNoPrizePop.less';
import API from "@/api";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import store from "@/store/store.ts";
import HomePage from '../../pages/HomePage/HomePage.js';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import { LOG_KEY, MatterShareOpt, MatterViewOpt, pageView, sensorLog,MatterViewDuration } from '../../utils/sensors.js';

@observer
class RankNoPrizePop extends React.Component<any, any> {

    componentDidMount(): void {
        pageView("b14290", {
            page_name: "排行榜未中奖弹窗",
        });
    
        sensorLog(LOG_KEY.exposure, "b14290", "d14291", {
            page_name: "排行榜未中奖弹窗",
            button_name: "我知道了按钮",
        });
    }
    clickBack = () => {
        ModalCtrl.closeModal();
    }
    clickBack2 = () => {
        sensorLog(LOG_KEY.click, "b14290", "d14291", {
            page_name: "排行榜未中奖弹窗",
            button_name: "我知道了按钮",
        });
        ModalCtrl.closeModal();
    }

    render() {
       const { prize } = this.props;
        return <div className="rankNoPrizePop">
            <div className="bg"></div>
            <div className="text">最终排名为{prize?.rank == -1 ? '3000+' : prize?.rank}</div>
            <div className="btn"  onClick={this.clickBack2}></div>
            <span className="back" onClick={this.clickBack}></span>
        </div>;
    }
}

export default RankNoPrizePop;