'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import { _asyncThrottle, _throttle } from '../../utils/utils.ts';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import store from "@/store/store.js";
import gameStore from "@/store/gameStore.js";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import HomePage from '@/pages/HomePage/HomePage.tsx';
import { LOG_KEY, pageView, sensorLog } from "../../utils/sensors.js";

@observer
class FailPopup extends React.Component {
    constructor(props) {
        super(props);
        this.state = props;
        // {
        //     targetStudy: 1,//还差合成数量，飞机
        //     targetTravel: 2//书包
        // }
    }

    componentDidMount = async () => {
        pageView("b14614", {
            page_name: "游戏失败弹窗",
        });
        sensorLog(LOG_KEY.exposure, "b14614", "d14617", {
            page_name: "游戏失败弹窗",
            button_name: "关闭按钮",
        });
        sensorLog(LOG_KEY.exposure, "b14614", "d14615", {
            page_name: "游戏失败弹窗",
            button_name: "再玩一次按钮",
        });
    };


    //关闭
    onClose = () => {
        sensorLog(LOG_KEY.click, "b14614", "d14617", {
          page_name: "游戏失败弹窗",
          button_name: "关闭按钮",
        });
        ModalCtrl.closeModal();
        PageCtrl.changePage(HomePage);//回到首页
    }

    //再玩一次
    onReceive = () => {
        sensorLog(LOG_KEY.click, "b14614", "d14615", {
          page_name: "游戏失败弹窗",
          button_name: "再玩一次按钮",
        });
        ModalCtrl.closeModal();
        PageCtrl.changePage(HomePage);//回到首页
        //重玩游戏
        // if (store.game) {
        //     const d = {
        //         targetStudy: gameStore.gameInfo.targetConfig.target1,
        //         targetTravel: gameStore.gameInfo.targetConfig.target2,
        //         time: gameStore.gameInfo.countdownSeconds
        //     }
        //     store.game.dispatchGlobalEvent("restartGame", d)
        // }
    }

    render() {
        const { gameData, data } = this.state || {}
        return (
            <div className="FailPopup">
                <div className="fp_mask"></div>
                <div className='fp_bg'>
                    <div className='fp_txt'>还需要合成以下个数才可解锁地标</div>
                    <div className='fp_icon'>
                        <div className='fp_mb_1'>还差{gameData?.targetTravel}个</div>
                        <div className='fp_mb_2'>还差{gameData?.targetStudy}个</div>
                    </div>
                    <div className='fp_btn md20' onClick={() => this.onReceive()}>
                        <div className='fp_btn_txt'>剩余次数：{data.leftGameTimes}</div>
                    </div>
                </div>
                <div className='fp_close' onClick={() => this.onClose()}></div>
            </div>
        );
    }
};

export default FailPopup;