'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import { unwatchPageVisibility, watchPageVisibility } from '@/core/page-visibility-notify.ts';
// import { handleLogClick, handleLogExposure } from '../../../MD';
// import { RES_PATH } from '../../../sparkrc';
import { _asyncThrottle, _throttle } from '../../utils/utils.ts';
import { TASK_CODE, CHANNEL_PARAMS, extranceName } from '../../utils/constants.ts';
import { setCookies } from '../../store/fetcher.ts';
import taskStore from '../../store/task.ts';
import { LOG_KEY, MatterShareOpt, MatterViewOpt, pageView, sensorLog, MatterViewDuration } from '../../utils/sensors';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import { Button } from '@grace/ui';
import store from '@/store/store';
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import HomePage from '@/pages/HomePage/HomePage.tsx';
import GiftPackPopup from '@/panels/GiftPackPopup/index.jsx';

@observer
class VictoryPopup extends React.Component {
    constructor(props) {
        super(props);
        this.state = props;
    }

    //关闭
    onClose = () => {
        ModalCtrl.closeModal();
        PageCtrl.changePage(HomePage)
    }

    //抽奖
    onDraw = ()=>{
        ModalCtrl.closeModal();
        // ModalCtrl.showModal(GiftPackPopup);
        store.doLotttery();
    }

    render() {
        return (
            <div className="VictoryPopup">
                <div className="vp_mask"></div>
                <div className='vp_title'></div>
                <div className='vp_ditu_txt'>{this.state?.gotSpInfo.name}地图</div>
                <div className='vp_guang'></div>
                <div className='vp_xz_icon' style={{backgroundImage: `url(${this.state?.gotSpInfo.icon})`}}></div>
                <div className='vp_cjjh_tips'>
                    <div>抽奖机会+{this.state?.rewardDrawTimes}</div>
                </div>
                <div className='vp_btn' onClick={()=>this.onDraw()}></div>
                <div className='vp_close' onClick={() => this.onClose()}></div>
            </div>
        );
    }
};

export default VictoryPopup;