import React from "react";
import {observer} from "mobx-react";
import "./TipPanel.less";
import {Button} from "@grace/ui";
import {_asyncThrottle} from "@/utils/utils.ts";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";

export interface ITipPanelProps {
  tip: string;
}

@observer
class TipPanel extends React.Component<ITipPanelProps> {

  componentDidMount() {
  }

  clickClose = () => {
    ModalCtrl.closeModal();
  };

  clickBtn = _asyncThrottle(async () => {
    ModalCtrl.closeModal();
  });

  render() {
    const { tip } = this.props;

    return <div className="SignSucPanel modal_center">
      <div className="bg"/>
      <div></div>
      <Button className="btn" onClick={this.clickBtn}/>
      <Button className="close" onClick={this.clickClose}/>
    </div>;
  }
}

export default TipPanel;
