'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './taskpop.less';
import { unwatchPageVisibility, watchPageVisibility } from '@/core/page-visibility-notify.ts';
import { handleLogClick, handleLogExposure } from '../../MD.ts';
// import { RES_PATH } from '../../../sparkrc';
import { _asyncThrottle, _throttle } from '../../utils/utils.ts';
import { TASK_CODE,CHANNEL_PARAMS, extranceName } from '../../utils/constants.ts';
import { setCookies } from '../../store/fetcher.ts';
import taskStore from '../../store/task.ts';
import { LOG_KEY, MatterShareOpt, MatterViewOpt, pageView, sensorLog,MatterViewDuration } from '../../utils/sensors';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import { Button } from '@grace/ui';
import store from "@/store/store.js";

@observer
class Taskpop extends React.Component {
  constructor(props) {
    super(props);
    this.startTime = +new Date();
  }

  async componentDidMount() {

    window.infoCallBack = taskStore.getInfoCallback;
    window.browseCallBack = taskStore.getBrowseCallback;

    await taskStore.getTaskList();
    watchPageVisibility(this.onPageVisibilityChange);

    this.initSensor();


  }

  initSensor() {

    MatterViewOpt("b14638", {
      page_name: "做任务，赚次数弹窗",
    });

    sensorLog(LOG_KEY.exposure, "b14638", "d14640", {
      page_name: "做任务，赚次数弹窗",
      button_name: "领取奖励按钮",
    });
    sensorLog(LOG_KEY.exposure, "b14638", "d14639", {
      page_name: "做任务，赚次数弹窗",
      button_name: "去完成按钮",
    });
  }

  componentWillUnmount() {
    unwatchPageVisibility(this.onPageVisibilityChange);
    MatterViewDuration("b14638", +new Date() - this.startTime, {
      page_name: "做任务，赚次数弹窗",
    });
  }

  onPageVisibilityChange = async (visible) => {
    if (visible) {
      await setCookies();
      await taskStore.getTaskList();
    }
  };

  /** 去完成 */
  taskDoHandle = _asyncThrottle(async (item) => {
    const {taskStatus, code} = item || {};
    handleLogClick(24, code, 1)
    if(code == TASK_CODE.INVITE){
      MatterShareOpt("b14638", "d14639", {
        button_name: "做任务，赚次数弹窗",
        page_name: "去完成按钮",
      })
    }else{

      sensorLog(LOG_KEY.click, "b14638", "d14639", {
        page_name: "做任务，赚次数弹窗",
        button_name: "去完成按钮",
      });
    }
    await taskStore.doTask(item);
  })

  /** 领奖 */
  taskPrizeHandle = _asyncThrottle(async (item) => {
    const { code, taskStatus } = item || {};
    handleLogClick(24, code, 2)
    sensorLog(LOG_KEY.click, "b14638", "d14640", {
      page_name: "做任务，赚次数弹窗",
      button_name: "领取奖励按钮",
    });

    await taskStore.getTaskPrize(item);
  })

  close = () => {
    ModalCtrl.closeModal()
    store.updateIndex()
  }

  render() {
    const {taskList} = taskStore;
    return (
      <div className="taskpop topPop_move">
        <span className="bg"></span>
        <Button className="close md23" onClick={this.close}></Button>
        <div className="list">
          {
            taskList?.length > 0 &&
            taskList.map((val, key) => {
              return (
                <div className="item" key={key}>
                  <span className="bg_item"></span>
                  <div className="center_info">
                    <span className="title">{`${val?.title}(${val?.completedSize}/${val?.intervalLimitSize})`}</span>
                    {/* 「浏览企业人人保」、「浏览畅行保产品计划A赠险」、「浏览畅行保产品计划B赠险」 app端任务描述取描述 后端直接接口处理了 */}
                    <span className="subtitle">{val?.subTitle}</span>
                  </div>
                  <img src={val?.icon} className="icon" />
                  <div className="btns">
                    {/* 去完成 */}
                    {
                      val?.taskStatus == 0 &&
                      (
                        CFG.channel != CHANNEL_PARAMS.RB_APP ||
                        (CFG.channel == CHANNEL_PARAMS.RB_APP && val?.code?.indexOf(TASK_CODE.BROWSE_SPECIAL_SHOW) < 0)
                      ) &&
                      <Button className="complete_btn" onClick={() => this.taskDoHandle(val)}></Button>
                    }
                    {/* 待领取 */}
                    {val?.taskStatus == 1 &&
                      <Button className="receive_btn" onClick={() => this.taskPrizeHandle(val)}></Button>}
                    {/* 已完成 */}
                    {val?.taskStatus == 2 && <Button className="already_btn"></Button>}
                  </div>
                </div>
              )
            })
          }
        </div>
      </div>
    );
  }
}

export default Taskpop;
