import React from "react";
import {observer} from "mobx-react";
import "./TipPanel.less";
import {Button} from "@grace/ui";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import { LOG_KEY, pageView, sensorLog } from "@/utils/sensors";

export interface ITipPanelProps {
  tip: string;
  onClose: () => void;
}

@observer
class TipPanel extends React.Component<ITipPanelProps> {

  componentDidMount() {
    pageView("b14273", {
      page_name: "提示弹窗"
    });
    sensorLog(LOG_KEY.exposure, "b14273", "d14275", {
      page_name: "提示弹窗",
      button_name: "关闭按钮",
    });
    sensorLog(LOG_KEY.exposure, "b14273", "d14274", {
      page_name: "提示弹窗",
      button_name: "我知道了按钮",
    });
  }

  clickClose = () => {
    ModalCtrl.closeModal();
    sensorLog(LOG_KEY.click, "b14273", "d14275", {
      page_name: "提示弹窗",
      button_name: "关闭按钮",
    });
    this.props.onClose && this.props.onClose();
  };

  clickBtn = () => {
    ModalCtrl.closeModal();
    sensorLog(LOG_KEY.click, "b14273", "d14274", {
      page_name: "提示弹窗",
      button_name: "我知道了按钮",
    });
    this.props.onClose && this.props.onClose();
  };

  render() {
    const { tip } = this.props;

    const isNoTimes = tip === "获取提示机会已用完";

    return <div className="TipPanel modal_center">
      <div className="bg"/>
      <div className="text" dangerouslySetInnerHTML={{
        __html: tip,
      }}/>
      <Button className={`btn md${isNoTimes ? 24 : 15}`} onClick={this.clickBtn}/>
      <Button className={`close ${isNoTimes ? "" : "md16"}`} onClick={this.clickClose}/>
    </div>;
  }
}

export default TipPanel;
