'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import { _asyncThrottle, _throttle } from '../../utils/utils.ts';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import store from "@/store/store.js";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import HomePage from '@/pages/HomePage/HomePage.tsx';

@observer
class FailPopup extends React.Component {
    constructor(props) {
        super(props);
    }

    //关闭
    onClose = () => {
        ModalCtrl.closeModal();
    }

    //开心收下
    onReceive = ()=>{

    }

    render() {
        return (
            <div className="FailPopup">
                <div className="fp_mask"></div>
                <div className='fp_bg'>
                    <div className='fp_txt'>还需要合成以下个数才可解锁地标</div>
                    <div className='fp_icon'></div>
                    <div className='fp_btn' onClick={()=>this.onReceive()}>
                        <div className='fp_btn_txt'>剩余次数：3</div>
                    </div>
                </div>
                <div className='fp_close' onClick={()=>this.onClose()}></div>
            </div>
        );
    }
};

export default FailPopup;