import Panel from "../../Module/Panel";
import { _decorator, Button, director, Label, Node, Sprite, } from "cc";
import store from "../store/store";
import { observer, render } from "../store/decorators";
import { _asyncThrottle, dateFormatter } from "../Utils/Utils";
import { changeScene, showPanel } from "../../Module/UIFast";
import SharePop from "./SharePop";
import { LOG_TYPE, sendLog } from "../Utils/WebNet/WebNet";
import { BlessingBagPage } from "../Scenes/BlessingBagPage";
import { UIMgr } from "../../Module/UIMgr";

const { ccclass, property } = _decorator;

@observer
@ccclass('RankPrizePanel')
export default class RankPrizePanel extends Panel {

  static bundle = "RankPrizePanel";
  static skin = "RankPrizePanel";

  @property(Node) closeBtn: Node = null;
  @property(Node) shareBtn: Node = null;
    @property(Node) goBag: Node = null;

  @property(Sprite) PrizeImg: Sprite = null;
  @property(Label) PrizeName: Label = null;
  @property(Label) PrizeTitle: Label = null;
  @property(Label) PrizeCount: Label = null;


  onLoad() {
    this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
    this.shareBtn.on(Button.EventType.CLICK, this.doShare);
      this.goBag.on(Button.EventType.CLICK, this.clickGoBag);
  }

  async start() {

    const { data = this.data } = this.data
    this.PrizeTitle.getComponent(Label).string = `${dateFormatter(data.openDate, "MM月dd日")} ${data.rankType == 1 ? "省份榜" : "个人榜"}模式中排名${data.index}名`
    this.PrizeName.getComponent(Label).string = data.prizeName;
    this.PrizeCount.getComponent(Label).string = "x" + data.count || "1";
    this.PrizeImg.getComponent(Sprite).spriteFrame = data.prizeImage;
  }

  clickClose = () => {
    this.hidePanel();
    setTimeout(() => {
      store.judgeMedalPop()
    }, 200);
  }

    clickGoBag = _asyncThrottle(async () => {
        if (!director.getScene().getComponent(BlessingBagPage)) {
            await changeScene(BlessingBagPage);
        }
        this.hidePanel();
    });

  doShare = _asyncThrottle(async () => {
    sendLog(LOG_TYPE.CLICK, 16)

    this.hidePanel();
    console.log("======", this.data);
    const prizeImg = this.data.prizeImage
    const prizeName = this.data.prizeName

    await showPanel(SharePop, { prizeImg, prizeName })
  })
}
