import Panel from "../../Module/Panel";
import {_decorator, Button, RichText, UITransform, Node, Sprite, Texture2D, ImageAsset, SpriteFrame, Label} from "cc";
import {observer, render} from "../store/decorators";
import {sendWebNetWithToken, WebNetName} from "db://assets/Scripts/Utils/WebNet/WebNet";
import {changeScene, showPanel} from "db://assets/Module/UIFast";
import {MyBagPanel} from "db://assets/Scripts/Panels/MyBagPanel";
import store from "../store/store";

const {ccclass, property} = _decorator;

@observer
@ccclass('ExchangeSuccess')
export default class ExchangeSuccess extends Panel {

    static bundle = "ExchangeSuccess";
    static skin = "ExchangeSuccess";

    @property(Node) look: Node = null;
    @property(Node) back: Node = null;
    @property(Label) prizeName: Label = null;
    @property(Sprite) prize: Sprite = null;

    onLoad() {
        this.look.on(Button.EventType.CLICK, this.clickLook);
        this.back.on(Button.EventType.CLICK, this.clickClose);
    }

    async start() {
        const {
            id,
            optionName,
            optionImg,
            spDetail,
            prizeId,
            userLimitCount,
            alreadyUserCount,
            consumeCreditsNum
        } = this.data;

        this.prizeName.string = optionName;

        this.prize.spriteFrame = optionImg;

        store.getExchangeInfo();
    }

    clickLook = async () => {
        this.hidePanel()
        showPanel(MyBagPanel, {tab:"TOOL"})
    }

    clickClose = async () => {
        this.hidePanel()
    }

}
