import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node, Sprite, } from "cc";
import store from "../store/store";
import { observer, render } from "../store/decorators";

const { ccclass, property } = _decorator;

import { HTMLRichText } from "../../Component/HTMLRichText/HTMLRichText";
import { sendWebNet, sendWebNetWithToken, WebNetName } from "../Utils/WebNet/WebNet";
import { strFormat } from "../Utils/Utils";
import { hidePanel, showPanel } from "../../Module/UIFast";
import SignSucPanel from "./SignSucPanel";

@observer
@ccclass('SignPanel')
export default class SignPanel extends Panel {

  static bundle = "SignPanel";
  static skin = "SignPanel1";

  @property(Node) closeBtn: Node = null;
  @property(Node) signBtn: Node = null;
  // @property(Node) signList: Node = null;

  @property(Node) day1: Node = null;
  @property(Node) day2: Node = null;
  @property(Node) day3: Node = null;
  @property(Node) day4: Node = null;
  @property(Node) day5: Node = null;
  @property(Node) day6: Node = null;
  @property(Node) day7: Node = null;

  onLoad() {
    this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
    this.signBtn.on(Button.EventType.CLICK, this.doSign);
  }

  signPrize = []
  signInfo = {}
  async start() {
    this.getSignInfo();
    this.getSignPrize();
  }

  clickClose = () => {
    this.hidePanel();
  }

  async getSignInfo() {

    const { success, data } = await sendWebNet(WebNetName.querySignInfo);
    if (!success) return;

    const resData = data
    // 有签到天数 但不是当期数据  说明上一期签完了 就展示已签到0天
    if (!resData.nowIssue && resData?.signDay > 0) {
      resData.signDay = 0
    }
    this.signInfo = resData

    for (let i = 1; i <= 7; i++) {
      const node = this[`day${i}`]
      // console.log("看看这里是什么结果",resData.signDay, i);
      if (resData.signDay >= i) {
        node.getChildByName("singed_mask").active = true;
      } else {
        node.getChildByName("singed_mask").active = false;
      }
    }
  }

  async getSignPrize() {
    const { success, data } = await sendWebNet(WebNetName.querySignPrize);
    if (success && data) {
      this.signPrize = data
    }

    for (let i = 0; i <= 6; i++) {
      const node = this[`day${i + 1}`]
      node.getChildByName("prizeNum").getComponent(Label).string =data[0].options[0].sendCount ? "x" + data[0].options[0].sendCount : "x0";
      node.getChildByName("prizeName").getComponent(Label).string = strFormat(data[0].options[0].name, 8);
      node.getChildByName("img_bg").getComponent(Sprite).spriteFrame = data[0].options[0].icon;
    }
  }


  async doSign() {
    const { success, data } = await sendWebNetWithToken(WebNetName.doSign);
    if (success) {
      showPanel(SignSucPanel, { prizeInfo: data });
      hidePanel()

      await store.updateIndex()
      // this.getSignInfo();
      // this.getSignPrize();
    }
  }

}
