import Panel from "../../Module/Panel";
import {
    _decorator,
    Button,
    Node,
    Sprite,
    Label,
    Prefab, instantiate
} from "cc";
import {observer, render} from "../store/decorators";
import {showPanel} from "db://assets/Module/UIFast";
import SharePop from "db://assets/Scripts/Panels/SharePop";
import Svga from "../../Component/Svga/Svga";
import {LOG_TYPE, sendLog} from "db://assets/Scripts/Utils/WebNet/WebNet";

const {ccclass, property} = _decorator;

@observer
@ccclass('GetPrize')
export default class GetPrize extends Panel {

    static bundle = "GetPrize";
    static skin = "GetPrize";

    @property(Node) share: Node = null;
    @property(Node) happy: Node = null;
    @property(Prefab) prizePrefab: Prefab = null;

    @property(Node) content: Node = null;

    @property(Node) svga: Node = null;
    @property(Node) bg: Node = null;

    onLoad() {

        this.happy.on(Button.EventType.CLICK, this.clickHappy, this);
        this.share.on(Button.EventType.CLICK, this.clickShare, this);
    }

    async start() {

        this.maidian()

        const {data = this.data} = this.data
        console.log(data)
        data.map((item, index) => {
            const prize = instantiate(this.prizePrefab)
            this.content.addChild(prize)

            const prizeName = prize.getChildByName("Label")
            prizeName.getComponent(Label).string = item.prizeName
            prize.getComponent(Sprite).spriteFrame = item.prizeImg


            const numBg = prize.getChildByName("numBg")
            const num = numBg.getChildByName("num")
            num.getComponent(Label).string = `X${item.sendCount}`
        })

        this.bg.active = false;
        this.svga.active = true

        this.scheduleOnce(() => {
            this.bg.active = true
            this.svga.active = false
        }, 1)
    }


    //埋点曝光
    maidian() {
        if (this.share.active == true) {
            sendLog(LOG_TYPE.EXPOSURE, Number("17"))
        }
    }

    clickShare() {
        showPanel(SharePop, {
            prizeName: this.data[0].prizeName,
            prizeImg: this.data[0].prizeImg,
        })
        sendLog(LOG_TYPE.CLICK, Number("17"))
        this.hidePanel()
    }

    clickHappy = () => {
        this.hidePanel()
    }
}
