import { _decorator, Animation, Component, Node } from "cc";
import { AudioMgr } from "../../../../core_tgx/base/AudioMgr";

const { ccclass, property } = _decorator;

@ccclass("PreCd")
export class PreCd extends Component {

    private static _ins: PreCd;
    static get ins() {
        return this._ins;
    }

    animation: Animation = null;

    constructor() {
        super();
        PreCd._ins = this;
    }

    protected onLoad() {
        this.node.active = false;
        this.animation = this.getComponent(Animation);
    }

    protected onDestroy() {
        if (PreCd._ins == this) {
            PreCd._ins = null;
        }
    }

    async startCd() {
        this.node.active = true;
        return new Promise<void>((resolve) => {
            AudioMgr.ins.playOneShot("audio/倒计时");
            this.animation.play();
            const callBack = () => {
                this.animation.off(Animation.EventType.FINISHED, callBack);
                this.node.active = false;
                resolve();
            };
            this.animation.once(Animation.EventType.FINISHED, callBack);
        });
    }

}

