import Panel from "../../Module/Panel";
import { _decorator, Button, Node, } from "cc";
import { observer } from "../store/decorators";

const { ccclass, property } = _decorator;

@observer
@ccclass('UnauthorizedPanel')
export default class UnauthorizedPanel extends Panel {

    static bundle = "UnauthorizedPanel";
    static skin = "UnauthorizedPanel";

    @property(Node) ok: Node = null;
    @property(Node) exit: Node = null;

    onLoad() {
        this.ok.on(Button.EventType.CLICK, this.clickOk);
        this.exit.on(Button.EventType.CLICK, this.clickExit);
    }

    clickOk = () => {
        this.hidePanel();
        this.data?.getAuthCode?.();
    }

    clickExit = () => {
    }


}
