import { _decorator, Collider2D, Component, RigidBody2D } from "cc";
import { Snake } from "db://assets/Scripts/Scenes/MainGame/Snake";
import { ECard, EPropType } from "../Common/Enums";

const { ccclass, property, requireComponent } = _decorator;

@ccclass("PropBase")
@requireComponent(RigidBody2D)
export class PropBase extends Component {

    canEaten: boolean = true;

    @property({ type: EPropType })
    tag: EPropType = EPropType.CARD_A;

    onLoad() {
        this.node.getComponent(Collider2D).tag = this.tag;
    }

    beEaten(target: Snake) {
        
    };

    recycle() {
        this.canEaten = true;
    };

}


