import { _decorator, Component, Label, Node, ProgressBar, Sprite, SpriteFrame, tween, Tween } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('progress')
export class progress extends Component {

    @property(Sprite) progressBg: Sprite = null;

    @property(Sprite) progressBar: Sprite = null;

    @property(Label) progressText: Label = null;

    @property([SpriteFrame]) spProgressBgFrames: SpriteFrame[] = [];


    @property([SpriteFrame]) spProgressBarFrames: SpriteFrame[] = [];

    @property([String]) spProgressTexts: string[] = [];


    private _leftTime: number;
    public get leftTime(): number {
        return this._leftTime;
    }
    public set leftTime(v: number) {
        this.tw?.removeSelf()
        this._leftTime = v;
    }

    tw: Tween<any> = null;


    start() {

    }

    /**
     * 
     * @param type 
     *
     */
    changeSpFrame(type) {
        this.progressBg.spriteFrame = this.spProgressBgFrames[type];
        this.progressBar.spriteFrame = this.spProgressBarFrames[type];
        this.progressText.string = this.spProgressTexts[type];
    }

    obj = {
        x: 0
    }

    changePro(pro) {
        this.obj.x = 0
        this.tw = tween(this.obj).to(this.leftTime, { x: 10 }, {
            onUpdate: (target, ratio) => {
                // console.warn("pro", pro * (1 - ratio))
                this.progressBg.getComponent(ProgressBar).progress = pro * (1 - ratio)
            },
            onComplete: () => {
                this.progressBg.getComponent(ProgressBar).progress = 0
            }
        }).start()
    }


    update(deltaTime: number) {

    }

    protected onDestroy(): void {
        Tween.stopAllByTarget(this.obj)
    }
}

