import Panel from "../../Module/Panel";
import {_decorator, Button, Node, Sprite, Label, SpriteFrame, tween, Layout} from "cc";
import { observer } from "../store/decorators";
import { hidePanel, showPanel } from "db://assets/Module/UIFast";
import {sendWebNet, sendWebNetWithToken, WebNetName} from "db://assets/Scripts/Utils/WebNet/WebNet";
import GetPrize from "db://assets/Scripts/Panels/GetPrize";
import { _asyncThrottle, sleep } from "../Utils/Utils";
import {AudioMgr} from "db://assets/core_tgx/base/AudioMgr";

const { ccclass, property } = _decorator;

@observer
@ccclass("OpenLuckyPanel")
export default class OpenLuckyPanel extends Panel {

    static bundle = "OpenLuckyPanel";
    static skin = "OpenLuckyPanel";


    @property(Node) svgaBg: Node = null;
    @property(Node) svgaOpen: Node = null;

    @property(Node) open: Node = null;
    @property(Node) cancel: Node = null;

    @property(Node) bag: Node = null;
    @property(Node) x5: Node = null;

    @property(SpriteFrame) sliverBag: SpriteFrame = null;
    @property(SpriteFrame) goldBag: SpriteFrame = null;
    @property(SpriteFrame) diamondBag: SpriteFrame = null;


    onLoad() {
        this.open.on(Button.EventType.CLICK, this.clickOpen, this);
        this.cancel.on(Button.EventType.CLICK, this.clickCancel, this);
    }

    start() {
        const { type, num = 1 } = this.data;
        this.bag.getComponent(Sprite).spriteFrame = {
            "sliver": this.sliverBag,
            "gold": this.goldBag,
            "diamond": this.diamondBag,
        }[type] || this.sliverBag;
        this.x5.active = num == 5;
    }

    clickOpen = _asyncThrottle(async () => {

        this.svgaBg.active = false;
        this.svgaOpen.active = true;
        this.open.active = this.cancel.active = false;

        const { type, num } = this.data;

        const drawType = {
            "sliver": 1,
            "gold": 2,
            "diamond": 3,
        }[type];

        const { success, data } = await sendWebNetWithToken(WebNetName.bagExchange, {
            drawType,
            drawCount: num,
        });

        if (!success) {
            this.hidePanel();
            return;
        }

        await sleep(2);

        this.hidePanel();
        showPanel(GetPrize, data.prizeVOList);

        await sendWebNet(WebNetName.bagPag)

        AudioMgr.ins.playOneShot("audio/福袋开启_合成音效");

    });

    clickCancel() {
        this.hidePanel();
    }

}
