import Panel from "../../Module/Panel";
import { _decorator, Button, Node, Animation, SpriteFrame, Sprite, Label } from "cc";
import { observer } from "../store/decorators";
import { creditsCost, LOG_TYPE, sendLog, sendWebNet, sendWebNetWithToken, WebNetName } from "../Utils/WebNet/WebNet";
import gameStore from "../store/gameStore";
import { MainGame } from "../Scenes/MainGame/MainGame";
import { hideShareGuide, showShareGuide, showToast } from "../../Module/UIFast";
import { unwatchPageVisibility, watchPageVisibility } from "../Utils/pageVisibilityNotify";
import { UIMgr } from "../../Module/UIMgr";

const { ccclass, property } = _decorator;

@observer
@ccclass("GameRevivePanel")
export default class GameRevivePanel extends Panel {

    static bundle = "GameRevivePanel";
    static skin = "GameRevivePanel";

    @property(Animation) cd: Animation = null;
    @property(Node) cardRevive: Node = null;
    @property(Node) creditsRevive: Node = null;
    @property(Node) shareRevive: Node = null;
    @property(Node) overBtn: Node = null;

    @property(Label) needCredits: Label = null;
    @property(Label) cardNum: Label = null;

    clickFlag: boolean = false;
    isClickShare: boolean = false;
    isReview: boolean = false;

    onLoad() {
        this.cardRevive.on(Button.EventType.CLICK, this.clickCard, this);
        this.creditsRevive.on(Button.EventType.CLICK, this.clickCredits, this);
        this.shareRevive.on(Button.EventType.CLICK, this.clickShare, this);
        this.overBtn.on(Button.EventType.CLICK, this.clickOver, this);

        // watchPageVisibility(this.onPageVisibility);

        sendLog(LOG_TYPE.EXPOSURE, 9)
        sendLog(LOG_TYPE.EXPOSURE, 10)
        sendLog(LOG_TYPE.EXPOSURE, 11)

    }

    onDestroy() {
        // unwatchPageVisibility(this.onPageVisibility);
    }

    // onPageVisibility = (visible) => {
    //     if (visible && this.isClickShare && !this.isReview) {
    //         hideShareGuide();
    //         this.review(3);
    //     }
    // };

    async start() {
        const {
            creditsNum, reviveEachNum,
            creditsReviveTimes, shareReviveTimes, cardReviveTimes,
            reviveCardNum
        } = this.data;

        this.needCredits.string = `${reviveEachNum}积分`;
        this.cardNum.string = `剩余${reviveCardNum}张`;

        if (creditsReviveTimes > 0 || reviveEachNum > creditsNum) {
            this.creditsRevive.getComponent(Sprite).grayscale = true;
            // this.creditsRevive.getComponent(Button).interactable = false;
        } else {
            this.creditsRevive.getComponent(Sprite).grayscale = false;
            // this.creditsRevive.getComponent(Button).interactable = true;
        }

        if (shareReviveTimes > 0) {
            this.shareRevive.getComponent(Sprite).grayscale = true;
            // this.shareRevive.getComponent(Button).interactable = false;
        } else {
            this.shareRevive.getComponent(Sprite).grayscale = false;
            // this.shareRevive.getComponent(Button).interactable = true;
        }

        if (cardReviveTimes > 0 || reviveCardNum <= 0) {
            this.cardRevive.getComponent(Sprite).grayscale = true;
            // this.cardRevive.getComponent(Button).interactable = false;
        } else {
            this.cardRevive.getComponent(Sprite).grayscale = false;
            // this.cardRevive.getComponent(Button).interactable = true;
        }

        this.cd.on(Animation.EventType.FINISHED, this.cdDone, this);
        this.cd.play();
    }

    async cdDone() {
        if (this.clickFlag) return;
        this.clickFlag = true;
        this.cd.off(Animation.EventType.FINISHED, this.cdDone);
        this.cd.stop();
        this.hidePanel();
        await gameStore.finalSubmit();
    }

    async review(type: 1 | 2 | 3, ticket?: string) {
        if (this.isReview) return;
        this.isReview = true;
        const param: any = {
            type,
            startId: gameStore.startInfo.startId,
        };

        if (type == 1) {
            param.ticketNum = ticket;
        }

        const { success } = await sendWebNetWithToken(WebNetName.reviveGame, param);

        if (!success) {
            this.cd.play();
            return;
        }

        this.hidePanel();

        MainGame.ins.review();
    }

    async clickCard() {
        sendLog(LOG_TYPE.CLICK, 9)

        if (this.clickFlag) return;

        const { cardReviveTimes, reviveCardNum } = this.data;

        if (cardReviveTimes > 0) {
            showToast("已使用道具复活机会");
            return;
        }

        if (reviveCardNum <= 0) {
            showToast("无复活卡");
            return;
        }

        this.clickFlag = true;

        this.cd.stop();

        await this.review(2);
    }

    async clickShare() {
        sendLog(LOG_TYPE.CLICK, 11)

        if (this.clickFlag) return;

        const { shareReviveTimes } = this.data;

        if (shareReviveTimes > 0) {
            showToast("已使用分享好友复活机会");
            return;
        }

        this.clickFlag = true;

        this.isClickShare = true;
        this.cd.stop();
        showShareGuide("分享好友后，点击屏幕即可复活");
        const clickGuide = () => {
            UIMgr.ins.shareGuide.off(Button.EventType.CLICK, clickGuide, this);
            hideShareGuide();
            this.review(3);
        };
        UIMgr.ins.shareGuide.once(Button.EventType.CLICK, clickGuide, this);

    }

    async clickCredits() {
        sendLog(LOG_TYPE.CLICK, 10)

        if (this.clickFlag) return;

        const { creditsNum, reviveEachNum, creditsReviveTimes } = this.data;

        if (creditsReviveTimes > 0) {
            showToast("已使用积分复活机会");
            return;
        }

        if (creditsNum < reviveEachNum) {
            showToast("积分不足");
            return;
        }

        this.clickFlag = true;

        this.cd.stop();

        const { success: costSuc, ticket } = await creditsCost("game", "reviveGame", "revive_deduct_desc", this.data.reviveEachNum);
        if (!costSuc) {
            showToast("预扣积分失败");
            this.cd.play();
            this.clickFlag = false;
            return;
        }

        await this.review(1, ticket);
    }

    async clickOver() {
        if (this.clickFlag) return;
        this.clickFlag = true;
        this.cd.getComponent(Animation).stop();
        this.hidePanel();
        await gameStore.finalSubmit();
    }

    // @render
    // render() {
    //     const {ruleInfo = ""} = store;
    //     this.setRuleTxt(ruleInfo);
    // }

}
