import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node, Sprite, } from "cc";
import store from "../store/store";
import { observer, render } from "../store/decorators";

const { ccclass, property } = _decorator;

@observer
@ccclass('SignSucPanel')
export default class SignSucPanel extends Panel {

  static bundle = "SignSucPanel";
  static skin = "SignSucPanel";

  @property(Node) closeBtn: Node = null;

  @property(Sprite) PrizeImg: Sprite = null;
  @property(Label) PrizeName: Label = null;
  @property(Label) PrizeCount: Label = null;

  onLoad() {
    this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
  }

  async start() {

    const { data = this.data } = this.data
    console.log("看看这里拿到了什么数", data.prizeInfo);
    this.PrizeName.getComponent(Label).string = data.prizeInfo.options[0].optionName;
    this.PrizeCount.getComponent(Label).string = data.prizeInfo.options[0].sendCount ? "x" + data.prizeInfo.options[0].sendCount : "x0";;
    this.PrizeImg.getComponent(Sprite).spriteFrame =  data.prizeInfo.options[0].optionImg;
  }

  clickClose = () => {
    this.hidePanel();
  }
}
