import {
    _decorator,
} from "cc";
import { ItemMgrBase } from "./ItemMgrBase";

const { ccclass, property } = _decorator;

/**
 * 食物管理器
 */
@ccclass("PropManager")
export class PropManager extends ItemMgrBase {

    private static _ins: PropManager = null;
    static get ins() {
        return this._ins;
    }

    constructor() {
        super();
        PropManager._ins = this;
    }

    onDestroy() {
        if (PropManager._ins == this) {
            PropManager._ins = null;
        }
    }

}
