import Panel from "../../Module/Panel";
import {_decorator, Button, Node, Sprite, Label, js, log, game, RenderTexture} from "cc";
import {observer} from "../store/decorators";
import store from "../store/store";
import shareStore from "../store/shareStore";

const {ccclass, property} = _decorator;

@observer
@ccclass('SharePop')
export default class SharePop extends Panel {

    static bundle = "SharePop";
    static skin = "SharePop";

    @property(RenderTexture) rt: RenderTexture = null;
    @property(Label) prizeName: Label = null;
    @property(Sprite) prizeImg: Sprite = null;
    @property(Sprite) qrcode: Sprite = null;



    start() {
        const {prizeName, prizeImg} = this.data

        this.prizeName.string = prizeName

        this.prizeImg.spriteFrame = prizeImg;

        this.qrcode.spriteFrame = shareStore.inviteInfo.qrCode;


        this.scheduleOnce(this.copyRenderTex, 0.5);
    }

    onClose = () => {
        this.hidePanel();
        this.dom && this.dom.remove();
        delete window["__tempClick"];
    };


    dom: HTMLDivElement = null;
    _tempCanvas: HTMLCanvasElement = null;
    _canvas: HTMLCanvasElement = null;

    copyRenderTex = () => {
        const width = this.rt.width;
        const height = this.rt.height;
        const buffer = this.rt.readPixels();

        if (!this._canvas) {
            this._canvas = document.createElement("canvas");
            this._canvas.width = width;
            this._canvas.height = height;
            this._tempCanvas = document.createElement("canvas");
            this._tempCanvas.width = width;
            this._tempCanvas.height = height;
        }

        const tempCtx = this._tempCanvas.getContext("2d");
        tempCtx.clearRect(0, 0, width, height);
        const imageData = tempCtx.createImageData(width, height);
        imageData.data.set(buffer);
        tempCtx.putImageData(imageData, 0, 0);

        const ctx = this._canvas.getContext("2d");
        ctx.scale(1, -1);
        ctx.drawImage(
            this._tempCanvas,
            0, 0, width, height,
            0, -height, width, height,
        );

        const posterImg = this._canvas.toDataURL();
        // console.log('this.posterBase64Data', this.posterBase64Data);

        // 本地预览海报结果时 可放开
        const wRem = width / 100;
        const hRem = height / 100;

        window["__tempClick"] = this.onClose;
        const domHtml = `
            <div
                onclick="window.__tempClick()"
                class="poster"
                style="
                    width: 100%;
                    height: 100%;
                    position: absolute;
                    left: 0;
                    top: 0;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                ">
                <img
                    src="${posterImg}" 
                    style="width: ${wRem}rem; height: ${hRem}rem; pointer-events: auto;"
                >
            </div>
        `

        this.dom = document.createElement("div");
        this.dom.innerHTML = domHtml;
        game.container.appendChild(this.dom);
    };

}
