import mobx from "mobx";
import {sendWebNet, WebNetName} from "../Utils/WebNet/WebNet";
import { IStartInfo } from "./gameStore";

const {makeAutoObservable} = mobx;


export interface IHomeInfo {
    actStartTime: number;
    actEndTime: number;
    currentTime: number;
    creditsNum: number;
    signPopFlag: boolean;
    continueSignDays: number;
    nickname: string;
    avatar: string;
    newGetSpId: string;
    rankInfos: {
        index: number;
        nickname: string;
        avatar: string;
    }[];
    rankPopList: {
        rankType: 1 | 2;
        openDate: string;
        index: number;
        prizeId: string;
        prizeName: string;
        prizeImage: string;
        count: number;
    }[];
    bagPopVO: {
        bagNum: number;
        bagName: string;
        bagImg: number;
    };
}


class Store {

    frontVariable: { [key in string]: any } = {}

    async updateFrontVariable() {
        const {success, data} = await sendWebNet(WebNetName.getFrontVariable);
        if (!success) {
            return;
        }
        this.frontVariable = data;
    }

    homeInfo: IHomeInfo = {
        actStartTime: Date.now(),
        actEndTime: Date.now() - 1000,
        currentTime: Date.now(),
        creditsNum: 0,
        signPopFlag: false,
        continueSignDays: 0,
        nickname: "",
        avatar: "",
        newGetSpId: null,
        rankInfos: [],
        rankPopList: [],
        bagPopVO: null,
    }

    async updateIndex() {
        const {success, data} = await sendWebNet(WebNetName.index);
        if (!success) {
            return;
        }

        this.homeInfo = data;
    }

    ruleInfo: string = "";

    async updateRule() {
        const {success, data} = await sendWebNet(WebNetName.projectRule);
        if (!success) {
            return;
        }
        this.ruleInfo = data;
    }

    // // 道具页接口
    // propPageInfo: {}
    //
    // async getPropPageInfo(credits: string) {
    //     const param = {
    //         credits,
    //     };
    //     const {success, data} = await sendWebNet(WebNetName.propPag,param);
    //     if (!success) {
    //         return;
    //     }
    //     this.propPageInfo = data
    //
    // }
}

const store: Store = makeAutoObservable(new Store());

export default store;