import { _decorator, Button, Component, Label, Node, } from 'cc';
import { observer } from '../store/decorators';
import Scene from '../../Module/Scene';
import { changeScene } from '../../Module/UIFast';
import { _asyncThrottle } from '../Utils/Utils';
import { HomeScene } from './HomeScene';
import { sendWebNet, WebNetName } from '../Utils/WebNet/WebNet';
import { YXCollectionView, YXIndexPath } from '../../Component/YXList/lib';
const { ccclass, property } = _decorator;

enum TAB {
  SHENG = "SHENG", // 省榜
  SINGLE = "SINGLE", // 个人榜
  FRIEND = "FRIEND", // 好友榜
}
@observer
@ccclass('RankScence')
export class RankScence extends Scene {
  static bundle: string = "RankScene";
  static skin: string = "RankScene";


  @property(Node) backBtn: Node = null;
  @property(Node) shareBtn: Node = null;

  @property(Node) Sheng: Node = null;
  @property(Node) Single: Node = null;
  @property(Node) Friend: Node = null;

  @property(Node) sheng_yes: Node = null;
  @property(Node) sheng_no: Node = null;
  @property(Node) single_yes: Node = null;
  @property(Node) single_no: Node = null;
  @property(Node) friend_yes: Node = null;
  @property(Node) friend_no: Node = null;

  @property(YXCollectionView) Sheng_List: YXCollectionView = null;
  @property(YXCollectionView) Single_List: YXCollectionView = null;
  @property(YXCollectionView) Friend_List: YXCollectionView = null;
  @property(Node) Sheng_MY: Node = null;
  @property(Node) Single_MY: Node = null;
  @property(Node) Friend_MY: Node = null;


  private _tab: TAB = TAB.SINGLE;
  set tab(tab: TAB) { // 设置tab切换
    this._tab = tab;
    const isSheng = tab == TAB.SHENG;
    const isSingle = tab == TAB.SINGLE;
    const isFriend = tab == TAB.FRIEND;

    this.sheng_yes.active = isSheng;
    this.sheng_no.active = !isSheng;
    this.single_yes.active = isSingle;
    this.single_no.active = !isSingle;
    this.friend_yes.active = isFriend;
    this.friend_no.active = !isFriend;
    // this.listBg.setScale(isDaily ? 1 : -1, 1, 1);

    this.Sheng.active = isSheng;
    this.Single.active = isSingle;
    this.Friend.active = isFriend;
  }

  get tab() {
    return this._tab;
  }


  shengDate: any[] = [];
  singleDate: any[] = [];
  friendDate: any[] = [];
  onLoad() {
    this.tab = TAB.SINGLE;

    this.backBtn.on(Button.EventType.CLICK, this.clickBackHome, this);
    this.shareBtn.on(Button.EventType.CLICK, this.clickShare, this);
    this.sheng_no.on(Button.EventType.CLICK, this.clickSheng, this);
    this.single_no.on(Button.EventType.CLICK, this.clickSingle, this);
    this.friend_no.on(Button.EventType.CLICK, this.clickFriend, this);
  }


  start() {

  }

  update(deltaTime: number) {

  }

  // 返回首页
  clickBackHome = _asyncThrottle(async () => {
    await changeScene(HomeScene);
  });

  // 分享按钮
  clickShare = _asyncThrottle(async () => {
    console.log("EDEN_TODO 记得分享按钮");
  });


  // 点击省榜 
  clickSheng() {
    this.tab = TAB.SHENG;
  }
  // 个人榜
  clickSingle() {
    this.tab = TAB.SINGLE;
  }
  // 好友榜
  clickFriend() {
    this.tab = TAB.FRIEND;
  }


  /******  数据 ******/
  // 刷新省榜
  async updateSheng() {
    const { success, data } = await sendWebNet(WebNetName.shengRank);
    if (!success) return;

    this.shengDate = data.rankList;
    this.Sheng_List.reloadData();
    this.onCellDisplay(this.Sheng_MY, data.myRank);

    this.Sheng_List.node.active = this.shengDate.length > 0;
    // this.dailyNoOne.active = this.dailyData.length <= 0; // 如果没有数据隐藏
  }

  // 刷新个人榜
  async updateSingle() {
    const { success, data } = await sendWebNet(WebNetName.singleRank);
    if (!success) return;

    this.shengDate = data.rankList;
    this.Sheng_List.reloadData();
    this.onCellDisplay(this.Sheng_MY, data.myRank);

    this.Sheng_List.node.active = this.shengDate.length > 0;
  }

  // 刷新好友榜
  async updateFriend() {
    const { success, data } = await sendWebNet(WebNetName.friendRank);
    if (!success) return;

    this.shengDate = data.rankList;
    this.Sheng_List.reloadData();
    this.onCellDisplay(this.Sheng_MY, data.myRank);

    this.Sheng_List.node.active = this.shengDate.length > 0;
  }

  // 给每个cell设置数据
  onDailyCellDisplay = (cell: Node, indexPath: YXIndexPath, collectionView: YXCollectionView) => {
    const data = this.shengDate[indexPath.item];
    this.onCellDisplay(cell, data);
  }

  onCellDisplay = (cell: Node, data) => {
    let { rank, nickname, score } = data;

    let rankTxt = rank;
    if (!rank) {
      if (score) {
        rankTxt = "1000+";
      } else {
        rankTxt = "-";
      }
    } else {
      if (rank > 1000) {
        rankTxt = "1000+";
      }
    }
    cell.getChildByName(`rank`).getComponent(Label).string = rankTxt;

    cell.getChildByName(`sheng`).getComponent(Label).string = nickname || "***";
    cell.getChildByName(`length`).getComponent(Label).string = score || "0";
  }

}

