import { _decorator, Button, Label, Node } from "cc";
import Scene from "db://assets/Module/Scene";
import { MainGame } from "./MainGame/MainGame";
import { changeScene, showPanel } from "db://assets/Module/UIFast";
import store from "../store/store";
import { observer, render } from "../store/decorators";
import { _asyncThrottle } from "../Utils/Utils";
import RankPanel from "../Panels/RankPanel";
import { UIMgr } from "../../Module/UIMgr";
import gameStore from "../store/gameStore";
import GameResultPanel from "../Panels/GameResultPanel";
import GamePosterPanel from "../Panels/GamePosterPanel";
import ExchangeSuccess from "db://assets/Scripts/Panels/ExchangeSuccess";
import { RankScence } from "./RankScene";
import {BlessingBagPage} from "db://assets/Scripts/Scenes/BlessingBagPage";
import {PropPage} from "db://assets/Scripts/Scenes/PropPage";

const { ccclass, property } = _decorator;

@observer
@ccclass('HomeScene')
export class HomeScene extends Scene {

  static bundle: string = "HomeScene";
  static skin: string = "HomeScene";
  // static group: string[] = ["HomeScene"];


  @property(Node) startBtn: Node = null;
  @property(Node) ruleBtn: Node = null;
  @property(Node) rankBtn: Node = null;
  @property(Node) blessBagBtn: Node = null;
  @property(Node) PropBtn: Node = null;

  @property(Label) userName: Label;
  @property(Label) pointNum: Label;
  @property(Label) fuDaiText: Label;
  @property(Label) signTxt: Label;

  onLoad() {
    this.startBtn.on(Button.EventType.CLICK, this.clickStart, this);
    this.ruleBtn.on(Button.EventType.CLICK, this.clickRule, this);
    this.rankBtn.on(Button.EventType.CLICK, this.clickRank, this);
    this.blessBagBtn.on(Button.EventType.CLICK, this.clickBag, this);
    this.PropBtn.on(Button.EventType.CLICK, this.clickProp, this);
  }

  async start() {

    await store.updateIndex();

    // showPanel(GamePosterPanel);

    UIMgr.ins.preloadScene(MainGame);
  }

  @render
  render() {
    const {
      nickname = "",
      creditsNum = 0,
    } = store.homeInfo || {};

    this.userName.string = nickname;
    this.pointNum.string = `${creditsNum}`;

  }

  clickStart = _asyncThrottle(async () => {
    await gameStore.startGame();
    changeScene(MainGame);

  });

  clickRule = _asyncThrottle(async () => {
    // showPanel(RulePanel);
  });

  clickRank = _asyncThrottle(async () => {
    await changeScene(RankScence);
  });

  clickBack = _asyncThrottle(() => {
  });

  clickBag = _asyncThrottle(async ()=>{
    await changeScene(BlessingBagPage)
  })


  clickProp = _asyncThrottle(async ()=>{
    await changeScene(PropPage)
  })
}

