import {_decorator, Button, instantiate, Label, Node, Prefab, Sprite} from 'cc';
import Scene from "db://assets/Module/Scene";
import {observer, render} from "../store/decorators";
import {sendWebNet, sendWebNetWithToken, WebNetName} from "db://assets/Scripts/Utils/WebNet/WebNet";
import {changeScene, showPanel} from "db://assets/Module/UIFast";
import openSliverPop from "db://assets/Scripts/Panels/openSliverPop";
import composedGoldPop from "db://assets/Scripts/Panels/composedGoldPop";
import composedDiamondPop from "db://assets/Scripts/Panels/composedDiamondPop";
import {HomeScene} from "db://assets/Scripts/Scenes/HomeScene";

const {ccclass, property} = _decorator;

@observer
@ccclass('BlessingBagPage')
export class BlessingBagPage extends Scene {

    static bundle: string = "BlessingBagPage";
    static skin: string = "BlessingBagPage";


    @property(Node) backBtn: Node = null;
    @property(Node) noactive_silverBag: Node = null;
    @property(Node) notactive_goldBag: Node = null;
    @property(Node) notactive_diamondBag: Node = null;
    @property(Node) notactive_toEarn: Node = null;
    @property(Node) Node_sliver: Node = null;
    @property(Node) Node_gold: Node = null;
    @property(Node) Node_diamond: Node = null;
    @property(Node) Node_earn: Node = null;

    @property(Node) Sliver_One_Btn: Node = null;
    @property(Node) Sliver_Five_Btn: Node = null;
    @property(Node) Gold_One_Btn: Node = null;
    @property(Node) Gold_Five_Btn: Node = null;
    @property(Node) Diamond_One_Btn: Node = null;
    @property(Node) Diamond_Five_Btn: Node = null;

    @property(Label) Label_num: Label = null;
    @property(Label) Label_five_gold: Label = null;
    @property(Label) Label_one_gold: Label = null;
    @property(Label) Label_five_diamond: Label = null;
    @property(Label) Label_one_diamond: Label = null;

    //福袋轮播图
    @property(Prefab) prize_list: Prefab = null;
    @property(Node) prizeListDiamond: Node = null;
    @property(Node) prizeListGold: Node = null;
    @property(Node) prizeListSliver: Node = null;


    //赚福袋任务界面
    @property(Prefab) earn_list: Prefab = null;
    @property(Node) content: Node = null;


    onLoad() {
        this.backBtn.on(Button.EventType.CLICK, this.backbtn, this);
        this.noactive_silverBag.on(Button.EventType.CLICK, this.silverBag, this);
        this.notactive_goldBag.on(Button.EventType.CLICK, this.goldBag, this);
        this.notactive_diamondBag.on(Button.EventType.CLICK, this.diamondBag, this);
        this.notactive_toEarn.on(Button.EventType.CLICK, this.toEarn, this);

        this.Sliver_One_Btn.on(Button.EventType.CLICK, this.SliverOneBtn, this);
        this.Sliver_Five_Btn.on(Button.EventType.CLICK, this.SliverFiveBtn, this);
        this.Gold_One_Btn.on(Button.EventType.CLICK, this.GoldOneBtn, this);
        this.Gold_Five_Btn.on(Button.EventType.CLICK, this.GoldFiveBtn, this);
        this.Diamond_One_Btn.on(Button.EventType.CLICK, this.DiamondOneBtn, this);
        this.Diamond_Five_Btn.on(Button.EventType.CLICK, this.DiamondFiveBtn, this);

        //赚福袋任务界面
        // this.Task1_invite_btn.on(Button.EventType.CLICK, this.DiamondFiveBtn, this);


    }

    bagInfo: any = {}
    TaskInfo = {}
    finishTaskInfo: any = {}

    async start() {
        this.Node_sliver.active = true;
        this.Node_gold.active = false;
        this.Node_diamond.active = false;
        this.Node_earn.active = false;

        const {success, data} = await sendWebNet(WebNetName.bagPag)

        if (!success) return

        this.bagInfo = data

        this.Label_num.string = `数量：${this.bagInfo.remainBagSilverNum}`
        this.Label_one_gold.string = `花费${this.bagInfo.bagSilverToGold}个银福袋`
        this.Label_five_gold.string = `花费${this.bagInfo.bagSilverToGold * 5}个银福袋`
        this.Label_one_diamond.string = `花费${this.bagInfo.bagSilverToDiamond}个银福袋`
        this.Label_five_diamond.string = `花费${this.bagInfo.bagSilverToDiamond * 5}个银福袋`


        let bagPrizeVO = this.bagInfo.bagPrizeVO
        console.log(bagPrizeVO, 222)

        bagPrizeVO.map((item, index) => {
            //银福袋轮播
            if (item.type === 1) {
                item.prizeVOList.map((item, index) => {

                    const prizeSliver = instantiate(this.prize_list)
                    this.prizeListSliver.addChild(prizeSliver)

                    prizeSliver.getComponent(Sprite).spriteFrame = item.prizeImg

                    const numBg = prizeSliver.getChildByName("numBg")
                    const num = numBg.getChildByName("num")
                    num.getComponent(Label).string = `X${item.sendCount}`

                    const prizeName = prizeSliver.getChildByName("prizeName")
                    prizeName.getComponent(Label).string = item.prizeName

                })
            }

            //金福袋轮播
            if (item.type === 2) {
                item.prizeVOList.map((item, index) => {
                    const prizeGold = instantiate(this.prize_list)
                    this.prizeListGold.addChild(prizeGold)

                    prizeGold.getComponent(Sprite).spriteFrame = item.prizeImg

                    const numBg = prizeGold.getChildByName("numBg")
                    const num = numBg.getChildByName("num")
                    num.getComponent(Label).string = `X${item.sendCount}`

                    const prizeName = prizeGold.getChildByName("prizeName")
                    prizeName.getComponent(Label).string = item.prizeName
                })
            }


            //钻石福袋轮播
            if (item.type === 3) {
                item.prizeVOList.map((item, index) => {
                    const prizeDiamond = instantiate(this.prize_list)
                    this.prizeListDiamond.addChild(prizeDiamond)

                    prizeDiamond.getComponent(Sprite).spriteFrame = item.prizeImg

                    const numBg = prizeDiamond.getChildByName("numBg")
                    const num = numBg.getChildByName("num")
                    num.getComponent(Label).string = `X${item.sendCount}`

                    const prizeName = prizeDiamond.getChildByName("prizeName")
                    prizeName.getComponent(Label).string = item.prizeName
                })
            }


        })


        //赚福袋任务界面
        const {success: TaskSuccess, data: TaskData} = await sendWebNetWithToken(WebNetName.taskList)
        if (!TaskSuccess) return
        this.TaskInfo = TaskData
        console.log(TaskData)
        let item = TaskData.item
        console.log(item)
        item.map((item: any, index: any) => {

            const EarnList = instantiate(this.earn_list)
            this.content.addChild(EarnList)
            const Label_task_name = EarnList.getChildByName("Label_task_name")
            Label_task_name.getComponent(Label).string = `${item.title}(${item.completedSize}/${item.intervalLimitSize})`

            const bag_num = EarnList.getChildByName("bag_num")
            bag_num.getComponent(Label).string = item.subTitle

            const activeBtn = EarnList.getChildByName("active_btn")
            const activeLabel = activeBtn.getChildByName("ActiveLabel")
            activeLabel.getComponent(Label).string = item.buttonText

            const notActiveBtn = EarnList.getChildByName("notActive_btn")
            const notActiveLabel = notActiveBtn.getChildByName("notActiveLabel")
            notActiveLabel.getComponent(Label).string = item.buttonText


            //判断是否完成，完成则置灰，不完成置亮
            if (item.completedSize >= item.intervalLimitSize) {
                activeBtn.active = false
                notActiveBtn.active = true
            } else {
                activeBtn.active = true
                notActiveBtn.active = false
            }

            //去完成任务
            activeBtn.on(Button.EventType.CLICK, () => this.clickTofinish(item.id, item.code, item.jumpUrl))
        })
    }

    // 点击返回按钮
    backbtn() {
        changeScene(HomeScene)
    }

    //银福袋按钮
    silverBag() {
        this.Node_sliver.active = true;
        this.Node_gold.active = false;
        this.Node_diamond.active = false;
        this.Node_earn.active = false;
    }

    //金福袋按钮
    goldBag() {
        this.Node_sliver.active = false;
        this.Node_gold.active = true;
        this.Node_diamond.active = false;
        this.Node_earn.active = false;
    }

    //钻石福袋按钮
    diamondBag() {
        this.Node_sliver.active = false;
        this.Node_gold.active = false;
        this.Node_diamond.active = true;
        this.Node_earn.active = false;
    }

    //去赚福袋按钮
    toEarn() {
        this.Node_sliver.active = false;
        this.Node_gold.active = false;
        this.Node_diamond.active = false;
        this.Node_earn.active = true;
    }

    //银福袋开启一个
    SliverOneBtn() {
        showPanel(openSliverPop, 1)
    }

    //银福袋开启五个
    SliverFiveBtn() {
        showPanel(openSliverPop, 5)
    }

    //金福袋开启一个
    GoldOneBtn() {
        showPanel(composedGoldPop, 1)
    }

    //金福袋开启五个
    GoldFiveBtn() {
        showPanel(composedGoldPop, 5)
    }

    //钻石福袋开启五个
    DiamondOneBtn() {
        showPanel(composedDiamondPop, 1)
    }

    //钻石福袋开启一个
    DiamondFiveBtn() {
        showPanel(composedDiamondPop, 5)
    }


    //去赚福袋任务
    async clickTofinish(taskId, taskCode, jumpUrl) {

        window.location.href = jumpUrl

        const {success, data} = await sendWebNetWithToken(WebNetName.finishTask, {taskId, taskCode})
        if (!success) return
        this.finishTaskInfo = data
    }


    //邀请

    invite() {

    }

    @render
    render() {
        // const {} = store.homeInfo || {};
    }
}

