import Panel from "../../Module/Panel";
import {_decorator, Button, Node, Sprite, Label} from "cc";
import {observer} from "../store/decorators";
import {showPanel} from "db://assets/Module/UIFast";
import ExchangeSuccess from "db://assets/Scripts/Panels/ExchangeSuccess";
import {sendWebNet, sendWebNetWithToken, WebNetName} from "db://assets/Scripts/Utils/WebNet/WebNet";
import * as cc from "cc";

const {ccclass, property} = _decorator;

@observer
@ccclass('ProPop')
export default class ProPop extends Panel {

    static bundle = "PropPop";
    static skin = "PropPop";

    @property(Label) prizeName: Label = null;
    @property(Node) closeBtn: Node = null;
    @property(Node) btn: Node = null;
    @property(Sprite) prize: Sprite = null;
    @property(Label) explanation: Label = null;
    @property(Label) num: Label = null;

    exchangeInfo = {}

    onLoad() {
        this.closeBtn.on(Button.EventType.CLICK, this.clickClose)
        this.btn.on(Button.EventType.CLICK, this.clickExchange)
    }

    start() {
        const {consumeSp, item, conditionsItem} = this.data
        console.log(consumeSp, item, conditionsItem, 112233445566)

        this.explanation.string = item.spDetail;

        const num = this.btn.getChildByName("num")
        num.getComponent(Label).string = consumeSp.quantity;

        this.prize.spriteFrame = item.optionImg;

        this.prizeName.string = item.optionName;
    }

    clickClose = () => {
        this.hidePanel();
    }

    clickExchange = async () => {
        //兑换接口
        const {success, data} = await sendWebNetWithToken(WebNetName.propExchange)
        if (!success) return
        this.exchangeInfo = data

        console.log(data,11223344)

        const {consumeSp, item, conditionsItem} = this.data

        // if (conditionsItem.credits >= consumeSp.quantity) {

            showPanel(ExchangeSuccess, {consumeSp, item, conditionsItem})

        // }
    }
}
