import Panel from "../../Module/Panel";
import { _decorator, Button, instantiate, Label, Node, Prefab, Sprite } from "cc";
import { observer } from "../store/decorators";
import { changeScene, showPanel } from "../../Module/UIFast";
import { HomeScene } from "../Scenes/HomeScene";
import GamePosterPanel from "./GamePosterPanel";

const { ccclass, property } = _decorator;

@observer
@ccclass("GameResultPanel")
export default class GameResultPanel extends Panel {

    static bundle = "GameResultPanel";
    static skin = "GameResultPanel";

    @property(Node) share: Node = null;
    @property(Node) again: Node = null;
    @property(Node) back: Node = null;
    @property(Node) prizeNode: Node = null;
    @property(Prefab) prizePrefab: Prefab = null;
    @property(Label) totalLength: Label = null;
    @property(Label) totalKill: Label = null;

    onLoad() {
        this.share.on(Button.EventType.CLICK, this.clickShare, this);
        this.again.on(Button.EventType.CLICK, this.clickAgain, this);
        this.back.on(Button.EventType.CLICK, this.clickBack, this);
    }

    async start() {
        const { finalKill, score, awardList } = this.data;

        this.totalKill.string = `${finalKill}`;
        this.totalLength.string = `${score}`;

        awardList.forEach(({ count, prizeName, prizeImage }) => {
            const node = instantiate(this.prizePrefab);
            this.prizeNode.addChild(node);

            const nameStr = prizeName + (count > 1 ? ` ×${count}` : "");
            node.getChildByName("name").getComponent(Label).string = nameStr;
            node.getChildByName("img").getComponent(Sprite).spriteFrame = prizeImage;
        });

    }

    clickShare() {
        const { finalKill, score } = this.data;

        showPanel(GamePosterPanel, {
            finalKill,
            score
        });
    }

    clickAgain() {
        this.hidePanel();
        changeScene(HomeScene);
    }

    clickBack() {
        this.hidePanel();
        changeScene(HomeScene);
    }

    // @render
    // render() {
    //     const {ruleInfo = ""} = store;
    //     this.setRuleTxt(ruleInfo);
    // }

}
