import { Label, _decorator } from "cc";
import { PropBtn } from "../Components/PropBtn";
import { Target } from "../Components/Target";
import { EPropType } from "../Common/Enums";
import { MainGame } from "../MainGame";
import gameStore from "../../../store/gameStore";
import { showToast } from "db://assets/Module/UIFast";
import { _asyncThrottle } from "../../../Utils/Utils";
const { ccclass } = _decorator;

@ccclass('DoubleExpPropBtn')
export class DoubleExpPropBtn extends PropBtn {



    start() {
        super.start();
        this.propNum = gameStore.startInfo.spCardList.filter(item => item.spId == 'sp_experience_card')[0]?.num || 0;
    }


    doUse = _asyncThrottle(async () => {
        if (!MainGame.ins.player.isLife) {
            return
        }
        if (this.propNum <= 0) {
            showToast('请在首页【游戏道具】中购买')
            return
        }

        if (gameStore.gameInfo.useSpCount >= gameStore.startInfo.eachUseLimitTimes) {
            showToast("本局使用道具达到上限")
            return
        }

        if (await gameStore.useProps('sp_experience_card')) {
            gameStore.gameInfo.useSpCount += 1
            super.doUse();
            this.propNum -= 1;
            MainGame.ins.player.useDouble()
            this.startCd();
        }
    })

}


