import Panel from "../../Module/Panel";
import {_decorator, Button, RichText, UITransform, Node, Sprite, Texture2D, ImageAsset, SpriteFrame, Label} from "cc";
import {observer, render} from "../store/decorators";

const {ccclass, property} = _decorator;

@observer
@ccclass('ExchangeSuccess')
export default class ExchangeSuccess extends Panel {

    static bundle = "ExchangeSuccess";
    static skin = "ExchangeSuccess";

    @property(Node) look: Node = null;
    @property(Node) back: Node = null;
    @property(Label) prizeName: Label = null;
    @property(Sprite) prize: Sprite = null;

    onLoad() {
        this.look.on(Button.EventType.CLICK, this.clickLook);
        this.back.on(Button.EventType.CLICK, this.clickClose);
    }

    async start() {
        const {consumeSp, item, conditionsItem} = this.data

        this.prizeName.string = item.optionName;

        this.prize.spriteFrame = item.optionImg;
    }

    clickLook() {
        console.log(12312312);
    }

    clickClose = () => {
        this.hidePanel()
    }

}
