// 事件名称定义
import { ccenum } from "cc";

export const Events = {
    Death: "Death",    // 设置游戏状态事件
};

// 食物类型枚举
export enum EPropType {
    FOOD,   // 普通食物
    LUCK_BAG,   // 福袋
    CARD_A,     // 卡片A
    CARD_B,     // 卡片B
    CARD_C,     // 卡片C
    MAGNET, // 磁铁
    SPEED,  // 加速
    SHIELD, // 护盾
    GROW,   // 加长
    DOUBLE_EXP, // 双倍经验
}

ccenum(EPropType);

export type ECard = EPropType.CARD_A | EPropType.CARD_B | EPropType.CARD_C;


// 移动方向枚举
export enum DirectionType {
    DEFAULT = 0,  // 默认方向
    LEFT = 1,     // 向左
    RIGHT = 2     // 向右
}

// 游戏状态枚举
export enum GameState {
    READY = 0,   // 准备状态
    PLAY = 1,    // 游戏中
    OVER = 3,    // 游戏结束
}


