import Panel from "../../Module/Panel";
import { _decorator, Button, game, Node } from "cc";
import store from "../store/store";
import { observer, render } from "../store/decorators";

const { ccclass, property } = _decorator;

@observer
@ccclass("RulePanel")
export default class RulePanel extends Panel {

    static bundle = "RulePanel";
    static skin = "RulePanel";

    @property(Node) closeBtn: Node = null;
    @property(Node) ruleNode: Node = null;
    @property(Node) content: Node = null;

    dom: HTMLDivElement;

    async onLoad() {
        // await store.updateRule();
        this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
    }

    @render
    render() {
        // const { success, data } = await sendWebNet(WebNetName.projectRule);
        // if (!success) return

        this.setRuleTxt(store.ruleInfo);
    }

    clickClose = () => {
        this.hidePanel();
        this.dom && this.dom.remove();
    };

    setRuleTxt(txt: string) {

        if (!this.dom) {
            this.dom = document.createElement("div");
        }

        this.dom.innerHTML = `
            <div
                class="poster"
                style="
                width: 8.35rem;
                height: 4.55rem;
                position: absolute;
                left: 3.995rem;
                top: 2rem;
                overflow: auto;
            ">
                <img
                    src="${store.frontVariable.ruleImg}"
                    style="width: 100%;"
                >
            </div>
        `;

        game.container.appendChild(this.dom);

        // const ruleNode = this.view['ScrollView/view/content/ruleTxt'];
        // const ruleTxt = this.ruleNode.getComponent(RichText);
        // // const content = this.view['ScrollView/view/content'];
        // ruleTxt.maxWidth = this.content.getComponent(UITransform).width;
        //
        // this.scheduleOnce(() => {
        //     ruleTxt.string = txt.replace(/<p\b.*?(?:\>|\/>)/gi, "").replace(/<\/p\>/gi, "<br/>");
        //     this.content.getComponent(UITransform).height = this.ruleNode.getComponent(UITransform).height;
        // }, 0.5);


        // this.spNode.getComponent(HTMLRichText).html = txt;

        // this.spNode.once(HTMLRichText.EventType.AFTER_RENDER, () => {

        //   const { width: pw, height: ph } = this.spNode.getComponent(UITransform);

        //   const width = this.spNode.parent.getComponent(UITransform).width;

        //   const height = ph * width / pw;

        //   this.spNode.getComponent(UITransform).setContentSize(width, height);

        // });
    }
}
