import { _decorator, Button, Label, Node, ScrollView, Size, Sprite, } from "cc";
import { observer } from "../store/decorators";
import Panel from "../../Module/Panel";
import { changeScene, hideWaiting, showWaiting } from "../../Module/UIFast";
import { _asyncThrottle, dateFormatter, strFormat } from "../Utils/Utils";
import { sendWebNet, sendWebNetWithToken, WebNetName } from "../Utils/WebNet/WebNet";
import { YXCollectionView, YXFlowLayout, YXIndexPath } from "../../Component/YXList/lib";
import { PropPage } from "../Scenes/PropPage";
import store from "../store/store";

const { ccclass, property } = _decorator;

@observer
@ccclass("LuckRecordPanel")
export class LuckRecordPanel extends Panel {
    static bundle: string = "LuckRecordPanel";
    static skin: string = "LuckRecordPanel";

    @property(Node) closeBtn: Node = null;
    @property(YXCollectionView) Prize_List: YXCollectionView = null;
    @property(Node) None_list: Node = null;

    recordArr: any[] = [];

    onLoad() {
        this.closeBtn.on(Button.EventType.CLICK, this.clickClose, this);
    }


    async start() {
        this.Prize_List.numberOfItems = () => this.recordArr.length;
        this.Prize_List.onCellDisplay = this.onPrizeCellDisplay;

        const prizeLayout = new YXFlowLayout();
        prizeLayout.itemSize = new Size(820, 140);
        prizeLayout.verticalSpacing = 24;
        this.Prize_List.layout = prizeLayout;
        this.Prize_List.reloadData();

        await this.updatePrize();

        this.Prize_List.node.on(ScrollView.EventType.SCROLL_TO_BOTTOM, this.updatePrize, this);
    }

    clickClose = () => {
        this.hidePanel();
    };

    pageNum = 1;
    totalPage = 1;
    pageSize = 50;

    // 刷新奖品
    async updatePrize() {
        if (this.pageNum > this.totalPage) return;

        showWaiting();
        const {
            success,
            data = { totalCount: 0, totalPage: 1, list: [] }
        } = await sendWebNet(WebNetName.bagRecords, { pageNum: this.pageNum, pageSize: this.pageSize });
        hideWaiting();

        if (!success) return;
        this.totalPage = data.totalPage;
        this.pageNum++;

        this.recordArr.push(...data.list);

        this.None_list.active = this.recordArr.length <= 0;
        this.Prize_List.node.active = this.recordArr.length > 0;

        this.Prize_List.reloadData();
    }

    onPrizeCellDisplay = (cell: Node, indexPath: YXIndexPath, collectionView: YXCollectionView) => {
        const data = this.recordArr[indexPath.item];
        this.onCellDisplay(cell, data);
    };

    onCellDisplay = (cell: Node, data) => {
        let {
            desc = 0,
            num = "",
            changeType = "",
            time = 0,
        } = data;

        cell.getChildByName(`name`)
            .getComponent(Label)
            .string = strFormat(`${desc}`, 32);

        cell.getChildByName(`time`)
            .getComponent(Label)
            .string = `${dateFormatter(time, "yyyy.MM.dd hh:mm")}${changeType == "1" ? "获得" : "消耗"}`;

        cell.getChildByPath("img/数量角标/num")
            .getComponent(Label).string = `x${num}`;
    };

}

