import { _decorator, EventKeyboard, Input, input, KeyCode, Node, } from "cc";
import Scene from "db://assets/Module/Scene";
import { Snake } from "db://assets/Scripts/Scenes/MainGame/Snake";


const { ccclass, property } = _decorator;


export enum DIR {
    UP,
    DOWN,
    LEFT,
    RIGHT,
}

@ccclass("MainGame1")
export class MainGame1 extends Scene {
    static bundle: string = "MainGame";
    static skin: string = "MainGame";

    @property(Node)
    snake: Node = null;

    @property
    speed: number = 200;

    onLoad() {
        input.on(Input.EventType.TOUCH_START, this.onTouchStart, this);
        input.on(Input.EventType.TOUCH_END, this.onTouchEnd, this);
        input.on(Input.EventType.TOUCH_CANCEL, this.onTouchEnd, this);

        input.on(Input.EventType.KEY_DOWN, this.onKeyDown, this);
        input.on(Input.EventType.KEY_UP, this.onKeyUp, this);
    }

    curDir: DIR = DIR.UP;

    keyArr = [];

    async start() {
        // this.schedule(() => {
        //     this.snake.getComponent(Snake).addNode();
        // }, 1);
    }

    onDestroy() {
        input.off(Input.EventType.TOUCH_START, this.onTouchStart, this);
        input.off(Input.EventType.TOUCH_END, this.onTouchEnd, this);
        input.off(Input.EventType.TOUCH_CANCEL, this.onTouchEnd, this);

        input.off(Input.EventType.KEY_DOWN, this.onKeyDown, this);
        input.off(Input.EventType.KEY_UP, this.onKeyUp, this);
    }

    onKeyDown(event: EventKeyboard) {

        const keyArr = [
            KeyCode.KEY_W,
            KeyCode.KEY_S,
            KeyCode.KEY_A,
            KeyCode.KEY_D,
        ];

        if (keyArr.indexOf(event.keyCode) > -1) {
            this.keyArr.push(event.keyCode);
        }

        this.setDir();
    }

    onKeyUp(event: EventKeyboard) {
        const index = this.keyArr.indexOf(event.keyCode);
        if (index > -1) {
            this.keyArr.splice(index, 1);
        }

        this.setDir();
    }

    setDir() {
        if (!this.keyArr.length) return;
        this.curDir = {
            [KeyCode.KEY_W]: DIR.UP,
            [KeyCode.KEY_S]: DIR.DOWN,
            [KeyCode.KEY_A]: DIR.LEFT,
            [KeyCode.KEY_D]: DIR.RIGHT,
        }[this.keyArr[this.keyArr.length - 1]];
    }

    onTouchStart(event: any) {

    }

    onTouchEnd(event: any) {

    }

    update(dt: number) {

        if (this.curDir == DIR.UP) {
            const newY = this.snake.position.y + this.speed * dt;
            this.snake.setPosition(this.snake.position.x, newY);
        } else if (this.curDir == DIR.DOWN) {
            const newY = this.snake.position.y - this.speed * dt;
            this.snake.setPosition(this.snake.position.x, newY);
        } else if (this.curDir == DIR.LEFT) {
            const newX = this.snake.position.x - this.speed * dt;
            this.snake.setPosition(newX, this.snake.position.y);
        } else if (this.curDir == DIR.RIGHT) {
            const newX = this.snake.position.x + this.speed * dt;
            this.snake.setPosition(newX, this.snake.position.y);
        }

    }

}
