import { _decorator, Component, Node, Sprite, Color } from "cc";

const { ccclass, property } = _decorator;

@ccclass("FastBtn")
export class FastBtn extends Component {
    // 是否处于加速状态
    _isFast: boolean = false;

    // 是否处于加速状态
    get isFast(): boolean {
        return this._isFast;
    }

    // 设置是否处于加速状态
    set isFast(value: boolean) {
        this._isFast = value;
    }

    // 按钮精灵组件
    @property(Sprite)
    sp: Sprite = null;

    onLoad() {
        this.node.on(Node.EventType.TOUCH_START, this.onTouchStart, this);
        this.node.on(Node.EventType.TOUCH_END, this.onTouchEnd, this);
        this.node.on(Node.EventType.TOUCH_CANCEL, this.onTouchEnd, this);
    }

    onDestroy() {
        this.node.targetOff(this);
        this.node.off(Node.EventType.TOUCH_START, this.onTouchStart, this);
        this.node.off(Node.EventType.TOUCH_END, this.onTouchEnd, this);
        this.node.off(Node.EventType.TOUCH_CANCEL, this.onTouchEnd, this);
    }

    // 按下时的处理
    onTouchStart() {
        this.isFast = true;
        this.node.emit("fast", true);
    }

    // 松开时的处理
    onTouchEnd() {
        this.isFast = false;
        this.node.emit("fast", false);
    }
}