
import { _decorator, Vec3, Node, math } from "cc";
const { ccclass, property } = _decorator;

@ccclass("AIBehaviorParams")
export class AIBehaviorParams {
    readonly BASE_VIEW_DISTANCE = 300;
    readonly INTERCEPT_DISTANCE = 350;
    readonly PREDICTION_TIME = 1.2;
    readonly ESCAPE_BOUNDARY = 150;

    constructor(private difficulty: number) {}

    get params() {
        return {
            reactionTime: math.lerp(0.8, 0.15, (this.difficulty - 1) / 4),
            viewDistance: this.BASE_VIEW_DISTANCE * (1 + (this.difficulty - 1) * 0.2),
            interceptDistance: this.INTERCEPT_DISTANCE * (1 + (this.difficulty - 1) * 0.2),
            aggressiveness: math.lerp(0.2, 0.7, (this.difficulty - 1) / 4),
            predictionAccuracy: math.lerp(0.6, 0.9, (this.difficulty - 1) / 4),
            turnSpeed: math.lerp(2, 4.5, (this.difficulty - 1) / 4)
        };
    }
} 