import Panel from "../../Module/Panel";
import { _decorator, Button, Node, Animation, SpriteFrame, Sprite, Label } from "cc";
import { observer } from "../store/decorators";
import { creditsCost, sendWebNet, sendWebNetWithToken, WebNetName } from "../Utils/WebNet/WebNet";
import gameStore from "../store/gameStore";
import { MainGame } from "../Scenes/MainGame/MainGame";

const { ccclass, property } = _decorator;

@observer
@ccclass("GameRevivePanel")
export default class GameRevivePanel extends Panel {

    static bundle = "GameRevivePanel";
    static skin = "GameRevivePanel";

    @property(Animation) cd: Animation = null;
    @property(Node) cardRevive: Node = null;
    @property(Node) creditsRevive: Node = null;
    @property(Node) shareRevive: Node = null;
    @property(Node) overBtn: Node = null;

    @property(Label) needCredits: Label = null;
    @property(Label) cardNum: Label = null;

    clickFlag: boolean = false;

    onLoad() {
        this.cardRevive.on(Button.EventType.CLICK, this.clickCard, this);
        this.creditsRevive.on(Button.EventType.CLICK, this.clickCredits, this);
        this.shareRevive.on(Button.EventType.CLICK, this.clickShare, this);
        this.overBtn.on(Button.EventType.CLICK, this.clickOver, this);
    }

    async start() {
        const {
            creditsNum, reviveEachNum,
            creditsReviveTimes, shareReviveTimes, cardReviveTimes,
            reviveCardNum
        } = this.data;

        this.needCredits.string = `${reviveEachNum}积分`;
        this.cardNum.string = `剩余${reviveCardNum}张`;

        if (creditsReviveTimes > 0 || reviveEachNum > creditsNum) {
            this.creditsRevive.getComponent(Sprite).grayscale = true;
            this.creditsRevive.getComponent(Button).interactable = false;
        } else {
            this.creditsRevive.getComponent(Sprite).grayscale = false;
            this.creditsRevive.getComponent(Button).interactable = true;
        }

        if (shareReviveTimes > 0) {
            this.shareRevive.getComponent(Sprite).grayscale = true;
            this.shareRevive.getComponent(Button).interactable = false;
        } else {
            this.shareRevive.getComponent(Sprite).grayscale = false;
            this.shareRevive.getComponent(Button).interactable = true;
        }

        if (cardReviveTimes > 0 || reviveCardNum <= 0) {
            this.cardRevive.getComponent(Sprite).grayscale = true;
            this.cardRevive.getComponent(Button).interactable = false;
        } else {
            this.cardRevive.getComponent(Sprite).grayscale = false;
            this.cardRevive.getComponent(Button).interactable = true;
        }

        this.cd.on(Animation.EventType.FINISHED, this.cdDone, this);
        this.cd.play();
    }

    async cdDone() {
        if (this.clickFlag) return;
        this.clickFlag = true;
        this.cd.off(Animation.EventType.FINISHED, this.cdDone);
        this.cd.stop();
        this.hidePanel();
        await gameStore.finalSubmit();
    }

    async review(type: 1 | 2 | 3, ticket?: string) {
        const param: any = {
            type,
            startId: gameStore.startInfo.startId,
        };

        if (type == 1) {
            param.ticket = ticket;
        }

        const { success } = await sendWebNetWithToken(WebNetName.reviveGame, param);

        if (!success) {
            this.cd.play();
            return;
        }

        this.hidePanel();

        MainGame.ins.review();
    }

    async clickCard() {
        if (this.clickFlag) return;
        this.clickFlag = true;
        this.cd.stop();

        await this.review(2);
    }

    async clickShare() {
        if (this.clickFlag) return;
        this.clickFlag = true;
        this.cd.stop();

    }

    async clickCredits() {
        if (this.clickFlag) return;
        this.clickFlag = true;
        this.cd.stop();

        const { success: costSuc, ticket } = await creditsCost("game", "reviveGame", "复活", this.data.reviveEachNum);
        if (!costSuc) {
            this.cd.play();
            return;
        }

        await this.review(1, ticket);
    }

    async clickOver() {
        if (this.clickFlag) return;
        this.clickFlag = true;
        this.cd.getComponent(Animation).stop();
        this.hidePanel();
        await gameStore.finalSubmit();
    }

    // @render
    // render() {
    //     const {ruleInfo = ""} = store;
    //     this.setRuleTxt(ruleInfo);
    // }

}
