import { _decorator, Button, Label, Node, Sprite } from "cc";
import Scene from "db://assets/Module/Scene";
import { MainGame } from "./MainGame/MainGame";
import { changeScene, showPanel, showToast } from "db://assets/Module/UIFast";
import store from "../store/store";
import { observer, render } from "../store/decorators";
import { _asyncThrottle, strFormat } from "../Utils/Utils";
import RankPanel from "../Panels/RankPanel";
import { UIMgr } from "../../Module/UIMgr";
import gameStore from "../store/gameStore";
import GameResultPanel from "../Panels/GameResultPanel";
import GamePosterPanel from "../Panels/GamePosterPanel";
import ExchangeSuccess from "db://assets/Scripts/Panels/ExchangeSuccess";
import { RankScence } from "./RankScene";
import { BlessingBagPage } from "db://assets/Scripts/Scenes/BlessingBagPage";
import { PropPage } from "db://assets/Scripts/Scenes/PropPage";
import { AudioMgr } from "../../core_tgx/base/AudioMgr";
import SignPanel from "../Panels/SignPanel";
import { PointDetailScene } from "./PointDetailScene";
import { MyBagPanel } from "../Panels/MyBagPanel";
import RulePanel from "../Panels/RulePanel";
import RankPrizePanel from "../Panels/RankPrizePanel";
import SnakeSkin from "../Panels/SnakeSkin";

const { ccclass, property } = _decorator;

@observer
@ccclass('HomeScene')
export class HomeScene extends Scene {

  static bundle: string = "HomeScene";
  static skin: string = "HomeScene";
  // static group: string[] = ["HomeScene"];


  @property(Node) startBtn: Node = null;
  @property(Node) ruleBtn: Node = null;
  @property(Node) rankBtn: Node = null;
  @property(Node) rankInfo1: Node = null;
  @property(Node) rankInfo2: Node = null;
  @property(Node) rankInfo3: Node = null;
  @property(Node) rankNone: Node = null;
  @property(Node) rankList: Node = null;
  @property(Node) blessBagBtn: Node = null;
  @property(Node) PropBtn: Node = null;
  @property(Node) signBtn: Node = null;
  @property(Node) pointBtn: Node = null;
  @property(Node) bagBtn: Node = null;

  @property(Label) userName: Label;
  @property(Label) pointNum: Label;
  @property(Label) fuDaiText: Label;
  @property(Label) signTxt: Label;

  onLoad() {
    this.startBtn.on(Button.EventType.CLICK, this.clickStart, this);
    this.ruleBtn.on(Button.EventType.CLICK, this.clickRule, this);
    this.rankBtn.on(Button.EventType.CLICK, this.clickRank, this);
    this.blessBagBtn.on(Button.EventType.CLICK, this.clickBag, this);
    this.PropBtn.on(Button.EventType.CLICK, this.clickProp, this);
    this.signBtn.on(Button.EventType.CLICK, this.clickSign, this);
    this.pointBtn.on(Button.EventType.CLICK, this.clickDetail, this);
    this.bagBtn.on(Button.EventType.CLICK, this.clickMyBag, this);
  }

  async start() {

    await store.updateIndex();
    await store.updateRule()

    const {
      signPopFlag,
      rankPopList,
      newGetSpId
    } = store.homeInfo || {};

    if (signPopFlag) { // 签到弹窗
      showPanel(SignPanel);
    }
    if (rankPopList.length > 0) { // 排行榜开奖弹窗
      // showPanel(RankPrizePanel);
      store.setRankPop()
    }

    if(newGetSpId == "sp_skin_snake_year"){
      showPanel(SnakeSkin)
    }

    UIMgr.ins.preloadScene(MainGame);
  }

  @render
  render() {
    const {
      nickname = "",
      creditsNum = 0,
      rankInfos = [],
      continueSignDays = 0,
    } = store.homeInfo || {};

    this.userName.string = strFormat(nickname, 8);
    this.pointNum.string = `${creditsNum > 9999999 ? "9999999+" : creditsNum}`;
    // this.fuDaiText.string = `${store.homeInfo?.fuDaiNum || 0}`;
    this.signTxt.string = `连续签到${continueSignDays || 0}天`;

    console.log(rankInfos.length, "rankInfos");
    
    if (rankInfos.length > 0) {
      this.rankList.active = true;
      this.rankNone.active = false;
      for (let i = 0; i <= 2; i++) {
        const node = this[`rankInfo${i + 1}`]
        node.getChildByName("rank_img").getComponent(Sprite).spriteFrame = rankInfos[i].avatar
        node.getChildByName("rank_name").getComponent(Label).string = strFormat(rankInfos[i].nickname, 8);
      }
    } else {
      this.rankList.active = false;
      this.rankNone.active = true;
    }
  }


  checkActTime = (isAllow = false) => {
    const { actStartTime, actEndTime, currentTime } = store.homeInfo || {};
    if (actStartTime > currentTime) {
      showToast("活动未开始")
      return false
    }
    if (actEndTime < currentTime && !isAllow) {
      showToast("活动已结束")
      return false
    }
    return true
  }

  clickStart = _asyncThrottle(async () => {
    if (!this.checkActTime()) return;

    await gameStore.startGame();
    changeScene(MainGame);

  });

  clickRule = _asyncThrottle(async () => {
    if (!this.checkActTime(true)) return;

    showPanel(RulePanel);
  });

  clickRank = _asyncThrottle(async () => {
    if (!this.checkActTime(true)) return;

    await changeScene(RankScence);
  });

  clickBack = _asyncThrottle(() => {
  });

  clickBag = _asyncThrottle(async () => {
    if (!this.checkActTime()) return;

    await changeScene(BlessingBagPage)
  })

  clickSign = _asyncThrottle(async () => {
    if (!this.checkActTime()) return;
    showPanel(SignPanel);
  });

  clickMyBag = _asyncThrottle(async () => {
    if (!this.checkActTime()) return;
    showPanel(MyBagPanel);
  });

  clickProp = _asyncThrottle(async () => {
    if (!this.checkActTime()) return;
    await changeScene(PropPage)
  })

  clickDetail = _asyncThrottle(async () => {
    if (!this.checkActTime()) return;
    await changeScene(PointDetailScene);
  });
}

