import * as fs from "fs";
import * as path from "path";
import JSZIP from "jszip";

//ȡĿ¼ļ
function readDir(zip, nowPath) {
    const files = fs.readdirSync(nowPath);
    files.forEach(function (fileName, index) {//Ŀ¼еļ
        console.log(fileName, index);//ӡǰȡļ
        const fillPath = nowPath + "/" + fileName;
        const file = fs.statSync(fillPath);//ȡһļ
        if (file.isDirectory()) {//Ŀ¼Ļѯ
            const dirlist = zip.folder(fileName);//ѹɸĿ¼
            readDir(dirlist, fillPath);//¼Ŀ¼ļ
        } else {
            // ųͼƬļ
            if (fileName.endsWith(".png") || fileName.endsWith(".jpg")) {
                return;
            }
            zip.file(fileName, fs.readFileSync(fillPath));//ѹĿ¼ļ
        }
    });
}

//ʼѹļ
export function zipDir(name, dir, dist) {
    return new Promise<void>((resolve, reject) => {
        const zip = new JSZIP();
        readDir(zip, dir);
        zip.generateAsync({//ѹʽʼ
            type: "nodebuffer",//nodejs
            compression: "DEFLATE",//ѹ㷨
            compressionOptions: {//ѹ
                level: 9
            }
        }).then(function (content) {
            fs.writeFileSync(`${dist}/${name}.zip`, content, "utf-8");
            resolve();
        });
    });
}

