import { _decorator } from "cc";
import { PropBase } from "./PropBase";
import { Snake } from "db://assets/Scripts/Scenes/MainGame/Snake";
import { CardManager } from "../Manager/CardManager";
import { ECard } from "../Common/Enums";

const { ccclass, property } = _decorator;

@ccclass("Card")
export class Card extends PropBase {

    onLoad() {
        super.onLoad();
    }

    beEaten = (target: Snake) => {
        target.addCard(this.tag as ECard);
    };

    recycle() {
        super.recycle();
        this.node.removeFromParent();
        this.node.destroy();
        CardManager.ins.check();
        // propPool.put(this.node);
    }

}