import { _decorator, Vec3, Node } from "cc";
import { Snake } from "../Snake";
import { AIState } from "./AIState";
import { AIBehaviorParams } from "./AIBehaviorParams";
import { AIDecision } from "./AIDecision";
import { AIMovement } from "./AIMovement";
import { AIPerception } from "./AIPerception";

const { ccclass, property } = _decorator;

@ccclass("AIController")
export class AIController {
    private snake: Snake;
    private params: AIBehaviorParams;
    private perception: AIPerception;
    private decision: AIDecision;
    private movement: AIMovement;

    constructor(snake: Snake, difficulty: number) {
        this.snake = snake;
        this.params = new AIBehaviorParams(difficulty);
        this.perception = new AIPerception(snake, this.params);
        this.decision = new AIDecision(this.params);
        this.movement = new AIMovement(snake, this.params);
    }

    update(dt: number) {
        if (!this.snake.isLife) return;

        // 感知环境
        const environment = this.perception.analyze();

        // 决策
        const decision = this.decision.makeDecision(environment);
        
        // 执行行为
        this.movement.execute(decision);
    }
} 