import { _decorator, Button, instantiate, js, Label, math, Node, Prefab, Sprite } from "cc";
import Scene from "db://assets/Module/Scene";
import {MainGame} from "./MainGame/MainGame";
import {changeScene, showPanel} from "db://assets/Module/UIFast";
import store from "../store/store";
import {observer, render} from "../store/decorators";
import {_asyncThrottle} from "../Utils/Utils";
import ProPop from "db://assets/Scripts/Panels/ProPop";
import {sendWebNet, WebNetName} from "db://assets/Scripts/Utils/WebNet/WebNet";
import {HomeScene} from "db://assets/Scripts/Scenes/HomeScene";
import { YXCollectionView, YXFlowLayout } from "../../Component/YXList/lib";


const {ccclass, property} = _decorator;

@observer
@ccclass('PropPage')
export class PropPage extends Scene {

    static bundle: string = "PropPage";
    static skin: string = "PropPage";
    // static group: string[] = ["HomeScene"];

    @property(Node) backBtn: Node = null;
    @property(Label) credits: Label = null;
    @property(Prefab) prizePrefab: Prefab = null;
    @property(Node) content: Node = null;

    /**
     * 列表组件
     */
    @property(YXCollectionView)
    listComp: YXCollectionView = null;

    propPageInfo: any = {};

    onLoad() {
        this.backBtn.on(Button.EventType.CLICK, this.clickToBack)
    }

    async start() {
        await this.getPropPageInfo()
        this.setCredits()
        this.setPrizeList()
    }

    async getPropPageInfo() {
        const {success, data} = await sendWebNet(WebNetName.propPag);
        if (!success) {
            return;
        }
        this.propPageInfo = data

        // this.listComp.numberOfItems = () => data.conditions.length;
        //
        // this.listComp.onCellDisplay = this.onCellDisplay;
        //
        // let layout = new YXFlowLayout();
        // layout.horizontalSpacing = 10;
        // layout.verticalSpacing = 10;
        // layout.itemSize = new math.Size(240, 400);
        // this.listComp.layout = layout;
        //
        // this.listComp.reloadData();
    }

    // onCellDisplay = (cell: Node, indexPath) => {
    //     const data = this.propPageInfo.conditions[indexPath.item];
    //
    //     const consumeSp = data.consumeSps[0];
    //     const item = data.options[0];
    //
    //     cell.getChildByName("prizeName")
    //         .getComponent(Label).string = item.spName;
    //
    //     cell.getChildByName("prize")
    //         .getComponent(Sprite).spriteFrame = item.optionImg;
    //
    //     cell.getChildByName("explain")
    //         .getComponent(Label).string = item.spDetail;
    //
    //     const btn = cell.getChildByName("btn");
    //
    //     btn.getChildByName("num2")
    //         .getComponent(Label).string = consumeSp.quantity;
    //
    //     btn.targetOff(Button.EventType.CLICK);
    //
    //     btn.on(Button.EventType.CLICK, () => this.clickToConfirm(consumeSp, item, data));
    // };

    /** 积分数据*/
    setCredits() {
        this.credits.string = this.propPageInfo.credits
    }

    /** 道具卡*/
    setPrizeList() {
        const conditions = this.propPageInfo.conditions
        conditions.map((conditionsItem, conditionsIndex) => {

            const consumeSp = conditionsItem.consumeSps[0]
            const item = conditionsItem.options[0]
            const prize = instantiate(this.prizePrefab)
            this.content.addChild(prize)

            const prizeName = prize.getChildByName("prizeName")
            prizeName.getComponent(Label).string = item.spName

            const prizeimg = prize.getChildByName("prize")
            prizeimg.getComponent(Sprite).spriteFrame = item.optionImg

            const explain = prize.getChildByName("explain")
            explain.getComponent(Label).string = item.spDetail

            const btn = prize.getChildByName("btn")
            const num2 = btn.getChildByName("num2")
            num2.getComponent(Label).string = consumeSp.quantity;


            btn.on(Button.EventType.CLICK, () => this.clickToConfirm(consumeSp, item, conditionsItem))

        })

        //遍历conditions
        //再遍历options
        //item 获取道具卡数量，展示道具数量
        //将数组内的图片、名字、道具说明加入到道具卡内

        //遍历option
        //将道具卡的预制体进行遍历
        //预制体内的名字、解释、图片 进行更替

    }



    // 点击返回按钮
    clickToBack() {
        changeScene(HomeScene)
    }

    clickToConfirm(consumeSp, item, conditionsItem) {
        showPanel(ProPop, {consumeSp, item, conditionsItem});
        console.log(consumeSp, item)
    }
}